/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.DeserializerSupport;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.ws.core.utils.DOMUtils;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.extensions.xop.jaxrpc.XOPUnmarshallerImpl;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Element;

public class Base64Deserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(Base64Deserializer.class);

    public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
        return this.deserialize(xmlName, xmlType, Base64Deserializer.sourceToString(xmlFragment), serContext);
    }

    private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
        }
        byte[] value = null;
        String valueStr = this.unwrapValueStr(xmlFragment);
        if (XOPContext.isXOPMessage()) {
            try {
                Element xopInclude = DOMUtils.parse(valueStr);
                String cid = xopInclude.getAttribute("href");
                XOPUnmarshallerImpl xopUnmarshaller = new XOPUnmarshallerImpl();
                value = xopUnmarshaller.getAttachmentAsByteArray(cid);
            }
            catch (IOException e) {
                throw new WSException("Failed to parse xopInclude element");
            }
        } else if (valueStr != null) {
            value = SimpleTypeBindings.unmarshalBase64(valueStr);
        }
        return value;
    }
}

