/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.builder;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilder {
    public abstract ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData var1);

    public abstract String getCode(ManagedConnectionFactoryDeploymentMetaData var1);

    public ServiceMetaData buildService(ManagedConnectionFactoryDeploymentMetaData mcfmd) {
        ServiceMetaData md = new ServiceMetaData();
        ObjectName on = this.buildObjectName(mcfmd);
        md.setObjectName(on);
        String code = this.getCode(mcfmd);
        md.setCode(code);
        ServiceConstructorMetaData cmd = this.buildConstructor(mcfmd);
        md.setConstructor(cmd);
        return md;
    }

    public ServiceMetaData build(ManagedConnectionFactoryDeploymentMetaData mcfmd) {
        ServiceMetaData md = this.buildService(mcfmd);
        List<ServiceAttributeMetaData> attributes = this.buildAttributes(mcfmd);
        md.setAttributes(attributes);
        List<ServiceDependencyMetaData> dependencies = this.buildDependencies(mcfmd);
        md.setDependencies(dependencies);
        return md;
    }

    public abstract List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData var1);

    public ServiceConstructorMetaData buildConstructor(ManagedConnectionFactoryDeploymentMetaData mcfmd) {
        ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
        constructor.setParameters(new Object[0]);
        constructor.setParams(new String[0]);
        return constructor;
    }

    public ServiceAttributeMetaData buildSimpleAttribute(String name, String value) {
        ServiceAttributeMetaData att = new ServiceAttributeMetaData();
        att.setName(name);
        ServiceTextValueMetaData dep = new ServiceTextValueMetaData(value);
        att.setValue(dep);
        return att;
    }

    public ServiceDependencyMetaData buildDependency(String dependencyName) {
        ServiceDependencyMetaData dependency = new ServiceDependencyMetaData();
        dependency.setIDependOn(dependencyName);
        return dependency;
    }

    public List<ServiceDependencyMetaData> buildDependencies(ManagedConnectionFactoryDeploymentMetaData md) {
        return new ArrayList<ServiceDependencyMetaData>();
    }

    public ServiceAttributeMetaData buildDependencyAttribute(String name, String dependency) {
        ServiceAttributeMetaData att = new ServiceAttributeMetaData();
        ServiceDependencyValueMetaData dep = new ServiceDependencyValueMetaData();
        dep.setDependency(dependency);
        if (name != null) {
            att.setName(name);
        }
        att.setValue(dep);
        return att;
    }
}

