/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager.xa;

import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.xa.JcaXid;

public class XAResourceWrapper
implements XAResource,
Serializable {
    private static final long serialVersionUID = 4551722165222496828L;
    private static final Logger log = Logger.getLogger(XAResourceWrapper.class);
    private XAResource xaResource;
    private boolean pad;
    private Boolean overrideRmValue;

    public XAResourceWrapper(XAResource resource) {
        this(Boolean.FALSE, false, resource);
    }

    public XAResourceWrapper(boolean pad, XAResource resource) {
        this(Boolean.FALSE, pad, resource);
    }

    public XAResourceWrapper(Boolean override, boolean pad, XAResource resource) {
        this.overrideRmValue = override;
        this.pad = pad;
        this.xaResource = resource;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (this.overrideRmValue != null) {
            if (log.isTraceEnabled()) {
                log.trace("Executing isSameRM with override value" + this.overrideRmValue + " for XAResourceWrapper" + this);
            }
            return this.overrideRmValue;
        }
        if (resource instanceof XAResourceWrapper) {
            XAResourceWrapper other = (XAResourceWrapper)resource;
            return this.xaResource.isSameRM(other.getResource());
        }
        return this.xaResource.isSameRM(resource);
    }

    public int prepare(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        return this.xaResource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int flag) throws XAException {
        return this.xaResource.setTransactionTimeout(flag);
    }

    public void start(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.start(xid, flags);
    }

    private Xid convertXid(Xid xid) {
        if (xid instanceof JcaXid) {
            return xid;
        }
        return new JcaXid(this.pad, xid);
    }

    private XAResource getResource() {
        return this.xaResource;
    }

    public String toString() {
        return super.toString();
    }
}

