/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.jms.ConnectionFactoryHelper;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsCred;
import org.jboss.resource.adapter.jms.JmsLocalTransaction;
import org.jboss.resource.adapter.jms.JmsManagedConnectionFactory;
import org.jboss.resource.adapter.jms.JmsMetaData;
import org.jboss.resource.adapter.jms.JmsSession;

public class JmsManagedConnection
implements ManagedConnection,
ExceptionListener {
    private static final Logger log = Logger.getLogger(JmsManagedConnection.class);
    private JmsManagedConnectionFactory mcf;
    private JmsConnectionRequestInfo info;
    private String user;
    private String pwd;
    private boolean isDestroyed;
    private Connection con;
    private Session session;
    private TopicSession topicSession;
    private QueueSession queueSession;
    private XASession xaSession;
    private XATopicSession xaTopicSession;
    private XAQueueSession xaQueueSession;
    private XAResource xaResource;
    private boolean xaTransacted;
    private Set handles = Collections.synchronizedSet(new HashSet());
    private Vector listeners = new Vector();

    public JmsManagedConnection(JmsManagedConnectionFactory mcf, ConnectionRequestInfo info, String user, String pwd) throws ResourceException {
        this.mcf = mcf;
        this.info = (JmsConnectionRequestInfo)info;
        this.user = user;
        this.pwd = pwd;
        this.setup();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JmsCred cred = JmsCred.getJmsCred(this.mcf, subject, info);
        if (this.user != null && !this.user.equals(cred.name)) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (cred.name != null && this.user == null) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        this.user = cred.name;
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        JmsSession handle = new JmsSession(this, (JmsConnectionRequestInfo)info);
        this.handles.add(handle);
        return handle;
    }

    private void destroyHandles() throws ResourceException {
        try {
            if (this.con != null) {
                this.con.stop();
            }
        }
        catch (Throwable t) {
            log.trace("Ignored error stopping connection", t);
        }
        Iterator iter = this.handles.iterator();
        while (iter.hasNext()) {
            ((JmsSession)iter.next()).destroy();
        }
        this.handles.clear();
    }

    public void destroy() throws ResourceException {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        try {
            this.con.setExceptionListener(null);
        }
        catch (JMSException e) {
            log.debug("Error unsetting the exception listener " + this, e);
        }
        this.destroyHandles();
        try {
            try {
                if (this.info.getType() == 2) {
                    this.topicSession.close();
                    if (this.xaTransacted) {
                        this.xaTopicSession.close();
                    }
                } else if (this.info.getType() == 1) {
                    this.queueSession.close();
                    if (this.xaTransacted) {
                        this.xaQueueSession.close();
                    }
                } else {
                    this.session.close();
                    if (this.xaTransacted) {
                        this.xaSession.close();
                    }
                }
            }
            catch (JMSException e) {
                log.debug("Error closing session " + this, e);
            }
            this.con.close();
        }
        catch (JMSException e) {
            throw new JBossResourceException("Could not properly close the session and connection", e);
        }
    }

    public void cleanup() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyed");
        }
        this.destroyHandles();
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (this.isDestroyed || !(obj instanceof JmsSession)) {
            throw new IllegalStateException("ManagedConnection in an illegal state");
        }
        JmsSession h = (JmsSession)obj;
        h.setManagedConnection(this);
        this.handles.add(h);
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        this.listeners.addElement(l);
        if (log.isTraceEnabled()) {
            log.trace("ConnectionEvent listener added: " + l);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        this.listeners.removeElement(l);
    }

    public XAResource getXAResource() throws ResourceException {
        if (!this.xaTransacted) {
            throw new NotSupportedException("Non XA transaction not supported");
        }
        if (this.xaResource == null) {
            this.xaResource = this.info.getType() == 2 ? this.xaTopicSession.getXAResource() : (this.info.getType() == 1 ? this.xaQueueSession.getXAResource() : this.xaSession.getXAResource());
        }
        if (log.isTraceEnabled()) {
            log.trace("XAResource=" + this.xaResource);
        }
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        JmsLocalTransaction tx = new JmsLocalTransaction(this);
        if (log.isTraceEnabled()) {
            log.trace("LocalTransaction=" + tx);
        }
        return tx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        return new JmsMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public void onException(JMSException exception) {
        if (this.isDestroyed) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring error on already destroyed connection " + this, exception);
            }
            return;
        }
        log.warn("Handling jms exception failure: " + this, exception);
        try {
            this.con.setExceptionListener(null);
        }
        catch (JMSException e) {
            log.debug("Unable to unset exception listener", e);
        }
        ConnectionEvent event = new ConnectionEvent(this, 5, exception);
        this.sendEvent(event);
    }

    protected Session getSession() {
        if (this.info.getType() == 2) {
            return this.topicSession;
        }
        if (this.info.getType() == 1) {
            return this.queueSession;
        }
        return this.session;
    }

    protected void sendEvent(ConnectionEvent event) {
        int type = event.getId();
        if (log.isTraceEnabled()) {
            log.trace("Sending connection event: " + type);
        }
        ConnectionEventListener[] list2 = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        block7: for (int i = 0; i < list2.length; ++i) {
            switch (type) {
                case 1: {
                    list2[i].connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    list2[i].localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    list2[i].localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    list2[i].localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    list2[i].connectionErrorOccurred(event);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + type);
                }
            }
        }
    }

    protected void removeHandle(JmsSession handle) {
        this.handles.remove(handle);
    }

    protected ConnectionRequestInfo getInfo() {
        return this.info;
    }

    protected JmsManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    void start() throws JMSException {
        this.con.start();
    }

    void stop() throws JMSException {
        this.con.stop();
    }

    protected String getUserName() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSProviderAdapter getProviderAdapter() throws NamingException {
        JMSProviderAdapter adapter;
        if (this.mcf.getJmsProviderAdapterJNDI() != null) {
            InitialContext ctx = new InitialContext();
            try {
                adapter = (JMSProviderAdapter)ctx.lookup(this.mcf.getJmsProviderAdapterJNDI());
            }
            finally {
                ctx.close();
            }
        } else {
            adapter = this.mcf.getJmsProviderAdapter();
        }
        return adapter;
    }

    private void setup() throws ResourceException {
        boolean trace = log.isTraceEnabled();
        try {
            JMSProviderAdapter adapter = this.getProviderAdapter();
            Context context = adapter.getInitialContext();
            boolean transacted = this.info.isTransacted();
            int ack = 1;
            if (this.info.getType() == 2) {
                String jndi2 = adapter.getTopicFactoryRef();
                if (jndi2 == null) {
                    throw new IllegalStateException("No configured 'TopicFactoryRef' on the jms provider " + this.mcf.getJmsProviderAdapterJNDI());
                }
                Object factory = context.lookup(jndi2);
                this.con = ConnectionFactoryHelper.createTopicConnection(factory, this.user, this.pwd);
                if (this.info.getClientID() != null) {
                    this.con.setClientID(this.info.getClientID());
                }
                this.con.setExceptionListener(this);
                if (trace) {
                    log.trace("created connection: " + this.con);
                }
                if (this.con instanceof XATopicConnection) {
                    this.xaTopicSession = ((XATopicConnection)this.con).createXATopicSession();
                    this.topicSession = this.xaTopicSession.getTopicSession();
                    this.xaTransacted = true;
                } else if (this.con instanceof TopicConnection) {
                    this.topicSession = ((TopicConnection)this.con).createTopicSession(transacted, ack);
                    if (trace) {
                        log.trace("Using a non-XA TopicConnection.  It will not be able to participate in a Global UOW");
                    }
                } else {
                    throw new JBossResourceException("Connection was not recognizable: " + this.con);
                }
                if (trace) {
                    log.trace("xaTopicSession=" + this.xaTopicSession + ", topicSession=" + this.topicSession);
                }
            } else if (this.info.getType() == 1) {
                String jndi3 = adapter.getQueueFactoryRef();
                if (jndi3 == null) {
                    throw new IllegalStateException("No configured 'QueueFactoryRef' on the jms provider " + this.mcf.getJmsProviderAdapterJNDI());
                }
                Object factory = context.lookup(jndi3);
                this.con = ConnectionFactoryHelper.createQueueConnection(factory, this.user, this.pwd);
                if (this.info.getClientID() != null) {
                    this.con.setClientID(this.info.getClientID());
                }
                this.con.setExceptionListener(this);
                if (trace) {
                    log.debug("created connection: " + this.con);
                }
                if (this.con instanceof XAQueueConnection) {
                    this.xaQueueSession = ((XAQueueConnection)this.con).createXAQueueSession();
                    this.queueSession = this.xaQueueSession.getQueueSession();
                    this.xaTransacted = true;
                } else if (this.con instanceof QueueConnection) {
                    this.queueSession = ((QueueConnection)this.con).createQueueSession(transacted, ack);
                    if (trace) {
                        log.trace("Using a non-XA QueueConnection.  It will not be able to participate in a Global UOW");
                    }
                } else {
                    throw new JBossResourceException("Connection was not reconizable: " + this.con);
                }
                if (trace) {
                    log.trace("xaQueueSession=" + this.xaQueueSession + ", queueSession=" + this.queueSession);
                }
            } else {
                String jndi4 = adapter.getFactoryRef();
                if (jndi4 == null) {
                    throw new IllegalStateException("No configured 'FactoryRef' on the jms provider " + this.mcf.getJmsProviderAdapterJNDI());
                }
                Object factory = context.lookup(jndi4);
                this.con = ConnectionFactoryHelper.createConnection(factory, this.user, this.pwd);
                if (this.info.getClientID() != null) {
                    this.con.setClientID(this.info.getClientID());
                }
                this.con.setExceptionListener(this);
                if (trace) {
                    log.trace("created connection: " + this.con);
                }
                if (this.con instanceof XAConnection) {
                    this.xaSession = ((XAConnection)this.con).createXASession();
                    this.session = this.xaSession.getSession();
                    this.xaTransacted = true;
                } else {
                    this.session = this.con.createSession(transacted, ack);
                    if (trace) {
                        log.trace("Using a non-XA Connection.  It will not be able to participate in a Global UOW");
                    }
                }
                if (trace) {
                    log.debug("xaSession=" + this.xaQueueSession + ", Session=" + this.session);
                }
            }
            if (trace) {
                log.debug("transacted=" + transacted + ", ack=" + ack);
            }
        }
        catch (NamingException e) {
            throw new JBossResourceException("Unable to setup connection", e);
        }
        catch (JMSException e) {
            throw new JBossResourceException("Unable to setup connection", e);
        }
    }
}

