/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.utility.StoppableThread;

public class InputMultiplexor {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$InputMultiplexor == null ? (class$org$jboss$remoting$transport$multiplex$InputMultiplexor = InputMultiplexor.class$("org.jboss.remoting.transport.multiplex.InputMultiplexor")) : class$org$jboss$remoting$transport$multiplex$InputMultiplexor);
    private static final int HEADER_LENGTH = 7;
    private int bufferSize;
    private int maxErrors;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$InputMultiplexor;

    public InputMultiplexor(Map configuration) {
        this.bufferSize = Multiplex.getOneParameter(configuration, "bufferSize", "multiplex.inputBufferSize", 4096);
        this.maxErrors = Multiplex.getOneParameter(configuration, "maxErrors", "multiplex.inputMaxErrors", 3);
    }

    public MultiGroupInputThread getaMultiGroupInputThread() throws IOException {
        return new MultiGroupInputThread();
    }

    public SingleGroupInputThread getaSingleGroupInputThread(MultiplexingManager manager, Socket socket, OutputStream os) throws IOException {
        return new SingleGroupInputThread(manager, socket, os);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CorruptedStreamException
    extends IOException {
        CorruptedStreamException(String message) {
            super(message);
        }
    }

    class SingleGroupInputThread
    extends StoppableThread {
        private InputStream is;
        private OutputStream currentOutputStream;
        private byte[] dataBytes;
        private MultiplexingManager manager;
        private int dataInCount;
        private int errorCount;
        private boolean eof;
        private byte[] headerBytes;
        private int headerCount;
        private byte version;
        private int destination;
        private short size;
        private boolean trace;
        private boolean debug;
        private boolean info;

        public SingleGroupInputThread(MultiplexingManager manager, Socket socket, OutputStream os) throws IOException {
            this.dataBytes = new byte[InputMultiplexor.this.bufferSize];
            this.dataInCount = 0;
            this.headerBytes = new byte[7];
            this.is = new BufferedInputStream(socket.getInputStream());
            this.manager = manager;
            this.currentOutputStream = os;
            this.trace = log.isTraceEnabled();
            this.debug = log.isDebugEnabled();
            this.info = log.isInfoEnabled();
        }

        public void shutdown() {
            super.shutdown();
            log.info("interrupting input thread");
            this.interrupt();
        }

        protected void doInit() {
            log.debug("SingleGroupInputThread thread starting");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void doRun() {
            block14: {
                block13: {
                    try {
                        try {
                            if (!this.completeHeader()) {
                                this.eof = true;
                                Object var6_1 = null;
                                if (!this.eof) return;
                                super.shutdown();
                                this.manager.setEOF();
                                return;
                            }
                            SocketId socketId = new SocketId(this.destination);
                            this.currentOutputStream = this.manager.getOutputStreamByLocalSocket(socketId);
                            if (this.currentOutputStream == null) {
                                log.info("unknown socket id: " + this.destination);
                                this.currentOutputStream = this.manager.getConnectedOutputStream(socketId);
                            }
                            int bytesRead = 0;
                            while (bytesRead < this.size) {
                                int n = this.is.read(this.dataBytes, 0, this.size - bytesRead);
                                if (n < 0) {
                                    this.eof = true;
                                    break block13;
                                }
                                this.currentOutputStream.write(this.dataBytes, 0, n);
                                bytesRead += n;
                                if (!this.trace) continue;
                                for (int i = 0; i < n; ++i) {
                                    log.trace("" + this.dataBytes[i]);
                                }
                            }
                            break block14;
                        }
                        catch (EOFException e) {
                            this.eof = true;
                            log.info("end of file");
                            Object var6_4 = null;
                            if (!this.eof) return;
                            super.shutdown();
                            this.manager.setEOF();
                            return;
                        }
                        catch (IOException e) {
                            if (++this.errorCount > InputMultiplexor.this.maxErrors) {
                                this.manager.setReadException(e);
                                super.shutdown();
                                log.error(e);
                            } else {
                                log.warn(e);
                            }
                            Object var6_5 = null;
                            if (!this.eof) return;
                            super.shutdown();
                            this.manager.setEOF();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (!this.eof) throw throwable;
                        super.shutdown();
                        this.manager.setEOF();
                        throw throwable;
                    }
                }
                Object var6_2 = null;
                if (!this.eof) return;
                super.shutdown();
                this.manager.setEOF();
                return;
            }
            Object var6_3 = null;
            if (!this.eof) return;
            super.shutdown();
            this.manager.setEOF();
        }

        private boolean completeHeader() throws IOException {
            while (this.headerCount < 7) {
                int n = this.is.read(this.headerBytes, this.headerCount, 7 - this.headerCount);
                if (n < 0) {
                    return false;
                }
                this.headerCount += n;
            }
            this.headerCount = 0;
            this.version = this.headerBytes[0];
            this.destination = this.headerBytes[1] << 24 | 0xFF0000 & this.headerBytes[2] << 16 | 0xFF00 & this.headerBytes[3] << 8 | 0xFF & this.headerBytes[4];
            this.size = (short)(0xFF00 & this.headerBytes[5] << 8 | 0xFF & this.headerBytes[6]);
            if (this.trace) {
                log.trace("version:     " + this.version);
                log.trace("destination: " + this.destination);
                log.trace("size:        " + this.size);
            }
            if (this.size < 0 || InputMultiplexor.this.bufferSize < this.size) {
                throw new CorruptedStreamException("invalid chunk size read on: " + this.manager + ": " + this.size);
            }
            if (this.version != 0) {
                throw new CorruptedStreamException("invalid version read on: " + this.manager + ": " + this.version);
            }
            return true;
        }

        protected void doShutDown() {
            log.debug("input thread: data bytes read: " + this.dataInCount);
            log.debug("input thread shutting down");
        }
    }

    public class MultiGroupInputThread
    extends StoppableThread {
        private static final String errMsg1 = "An existing connection was forcibly closed by the remote host";
        private static final String errMsg2 = "An established connection was aborted by the software in your host machine";
        private Map managerProcessorMap;
        private Set socketGroupsToBeRegistered = new HashSet();
        private Set tempSocketGroupSet = new HashSet();
        private boolean socketGroupsAreWaiting;
        private Selector selector;
        private ByteBuffer buffer;
        private byte[] data;
        private boolean trace;
        private boolean debug;
        private boolean info;

        public MultiGroupInputThread() throws IOException {
            this.managerProcessorMap = Collections.synchronizedMap(new HashMap());
            this.selector = Selector.open();
            this.buffer = ByteBuffer.allocate(InputMultiplexor.this.bufferSize);
            this.data = new byte[InputMultiplexor.this.bufferSize];
            this.trace = log.isTraceEnabled();
            this.debug = log.isDebugEnabled();
            this.info = log.isInfoEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerSocketGroup(MultiplexingManager manager) throws IOException {
            if (this.debug) {
                log.debug(" accepting socket group for registration: " + manager);
            }
            Set set = this.socketGroupsToBeRegistered;
            synchronized (set) {
                this.socketGroupsToBeRegistered.add(manager);
                this.socketGroupsAreWaiting = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRegistration() {
            this.tempSocketGroupSet.clear();
            Set set = this.socketGroupsToBeRegistered;
            synchronized (set) {
                this.tempSocketGroupSet.addAll(this.socketGroupsToBeRegistered);
                this.socketGroupsToBeRegistered.clear();
                this.socketGroupsAreWaiting = false;
            }
            Iterator it = this.tempSocketGroupSet.iterator();
            while (it.hasNext()) {
                MultiplexingManager manager = (MultiplexingManager)it.next();
                GroupProcessor groupProcessor = new GroupProcessor(manager);
                SocketChannel channel = manager.getSocket().getChannel();
                try {
                    SelectionKey key = ((SelectableChannel)channel).register(this.selector, 1, groupProcessor);
                    groupProcessor.setKey(key);
                    this.managerProcessorMap.put(manager, groupProcessor);
                }
                catch (IOException e) {
                    log.warn(e);
                }
            }
        }

        public void unregisterSocketGroup(MultiplexingManager manager) {
            GroupProcessor groupProcessor = (GroupProcessor)this.managerProcessorMap.get(manager);
            if (groupProcessor == null) {
                log.debug("attempting to unregister unknown MultiplexingManager: " + manager);
                return;
            }
            SelectionKey key = groupProcessor.getKey();
            key.cancel();
            this.managerProcessorMap.remove(manager);
            if (this.debug) {
                log.debug("unregistered socket group:" + manager);
            }
        }

        public void shutdown() {
            super.shutdown();
            try {
                this.selector.close();
            }
            catch (IOException e) {
                log.error("unable to close selector", e);
            }
            this.interrupt();
        }

        protected void doInit() {
            log.debug("MultiGroupInputThread thread starting");
        }

        protected void doRun() {
            log.debug("entering doRun()");
            Set<SelectionKey> keys = null;
            try {
                do {
                    if (!this.running) {
                        return;
                    }
                    if (this.socketGroupsAreWaiting) {
                        this.doRegistration();
                    }
                    this.selector.select(200L);
                } while ((keys = this.selector.selectedKeys()).isEmpty());
            }
            catch (IOException e) {
                log.info(e);
            }
            catch (ClosedSelectorException e) {
                log.info("Selector is closed: shutting down input thread");
                super.shutdown();
                return;
            }
            if (this.trace) {
                log.trace("keys: " + this.selector.keys().size());
                log.trace("selected keys: " + keys.size());
            }
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                SelectionKey key = (SelectionKey)it.next();
                it.remove();
                GroupProcessor groupProcessor = (GroupProcessor)key.attachment();
                if (groupProcessor == null) {
                    if (!key.isValid()) continue;
                    log.error("valid SelectionKey has no attachment: " + key);
                    continue;
                }
                groupProcessor.processChannel(key);
            }
        }

        protected void doShutDown() {
            log.debug("MultiGroupInputThread shutting down");
        }

        class GroupProcessor {
            private byte[] b = new byte[7];
            private int headerCount;
            private byte version;
            private int destination;
            private short size;
            private MultiplexingManager manager;
            private OutputStream outputStream;
            private SelectionKey key;
            private int errorCount;

            public GroupProcessor(MultiplexingManager manager) {
                this.manager = manager;
            }

            public void processChannel(SelectionKey key) {
                log.debug("processChannel()");
                SocketChannel channel = (SocketChannel)key.channel();
                MultiGroupInputThread.this.buffer.clear();
                try {
                    if (channel.read(MultiGroupInputThread.this.buffer) < 0) {
                        throw new EOFException();
                    }
                    MultiGroupInputThread.this.buffer.flip();
                    if (MultiGroupInputThread.this.debug) {
                        log.debug("read: " + MultiGroupInputThread.this.buffer.remaining());
                    }
                    while (MultiGroupInputThread.this.buffer.hasRemaining()) {
                        if (this.headerCount < 7 || this.size == 0) {
                            this.completeHeader(MultiGroupInputThread.this.buffer);
                            if (this.headerCount < 7) {
                                return;
                            }
                            SocketId socketId = new SocketId(this.destination);
                            this.outputStream = this.manager.getOutputStreamByLocalSocket(socketId);
                            if (this.outputStream == null) {
                                log.info("unknown socket id: " + this.destination);
                                this.outputStream = this.manager.getConnectedOutputStream(socketId);
                            }
                            if (!MultiGroupInputThread.this.buffer.hasRemaining()) {
                                return;
                            }
                        }
                        int n = Math.min(this.size, MultiGroupInputThread.this.buffer.remaining());
                        MultiGroupInputThread.this.buffer.get(MultiGroupInputThread.this.data, 0, n);
                        this.outputStream.write(MultiGroupInputThread.this.data, 0, n);
                        if (MultiGroupInputThread.this.trace) {
                            log.trace("received " + n + " bytes for socket: " + this.destination);
                            for (int i = 0; i < n; ++i) {
                                log.trace("" + (0xFF & MultiGroupInputThread.this.data[i]));
                            }
                        }
                        this.size = (short)(this.size - n);
                        if (this.size != 0) continue;
                        this.headerCount = 0;
                    }
                }
                catch (IOException e) {
                    this.handleChannelException(e, key, channel);
                }
                catch (Throwable t) {
                    log.error("doRun()");
                    log.error(t);
                }
            }

            public SelectionKey getKey() {
                return this.key;
            }

            public void setKey(SelectionKey key) {
                this.key = key;
            }

            private void completeHeader(ByteBuffer bb) throws IOException {
                int n = Math.min(bb.remaining(), 7 - this.headerCount);
                bb.get(this.b, this.headerCount, n);
                this.headerCount += n;
                if (this.headerCount == 7) {
                    this.version = this.b[0];
                    this.destination = this.b[1] << 24 | 0xFF0000 & this.b[2] << 16 | 0xFF00 & this.b[3] << 8 | 0xFF & this.b[4];
                    this.size = (short)(0xFF00 & this.b[5] << 8 | 0xFF & this.b[6]);
                    if (this.size < 0 || InputMultiplexor.this.bufferSize < this.size) {
                        throw new CorruptedStreamException("invalid chunk size read on: " + this.manager + ": " + this.size);
                    }
                    if (this.version != 0) {
                        throw new CorruptedStreamException("invalid version read on: " + this.manager + ": " + this.version);
                    }
                }
            }

            private void handleChannelException(IOException e, SelectionKey key, SocketChannel channel) {
                log.error("handleChannelException()");
                log.error(e);
                try {
                    if (!channel.isOpen()) {
                        key.cancel();
                        return;
                    }
                    if (e instanceof EOFException) {
                        key.cancel();
                        this.manager.setEOF();
                        log.debug(e);
                        return;
                    }
                    if (++this.errorCount > InputMultiplexor.this.maxErrors) {
                        this.manager.setReadException(e);
                        channel.close();
                        key.cancel();
                        log.error(e);
                        log.error("error count exceeds max errors: " + this.errorCount);
                        return;
                    }
                    Socket socket = channel.socket();
                    String message = e.getMessage();
                    if (socket.isClosed() || socket.isInputShutdown() || MultiGroupInputThread.errMsg1.equals(message) || MultiGroupInputThread.errMsg2.equals(message) || e instanceof CorruptedStreamException) {
                        this.manager.setReadException(e);
                        channel.close();
                        key.cancel();
                        log.info(e);
                        return;
                    }
                    log.warn(e);
                }
                catch (IOException e2) {
                    log.error("problem closing channel: " + this.manager, e2);
                }
            }

            public int getDestination() {
                return this.destination;
            }

            public short getSize() {
                return this.size;
            }

            public byte getVersion() {
                return this.version;
            }

            public OutputStream getOutputStream() {
                return this.outputStream;
            }
        }
    }
}

