/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.serializable;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.PreferredStreamMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class SerializableMarshaller
implements PreferredStreamMarshaller {
    static final long serialVersionUID = -5553685435323600244L;
    public static final String DATATYPE = "serializable";
    String serializationType;

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public String getSerializationType() {
        if (this.serializationType == null) {
            return "java";
        }
        return this.serializationType;
    }

    public OutputStream getMarshallingStream(OutputStream outputStream) throws IOException {
        return this.getMarshallingStream(outputStream, null);
    }

    public OutputStream getMarshallingStream(OutputStream outputStream, Map config) throws IOException {
        if (outputStream instanceof ObjectOutputStream) {
            return outputStream;
        }
        BufferedOutputStream bos = new BufferedOutputStream(outputStream);
        SerializationManager manager = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
        ObjectOutputStream oos = manager.createOutput(bos);
        oos.flush();
        return oos;
    }

    public void write(Object dataObject, OutputStream output) throws IOException {
        ObjectOutputStream oos = (ObjectOutputStream)this.getMarshallingStream(output, null);
        SerializationStreamFactory.getManagerInstance(this.getSerializationType()).sendObject(oos, dataObject);
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new SerializableMarshaller();
    }
}

