/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;

public class ArrayInfoImpl
extends ClassInfoImpl
implements ArrayInfo {
    private static final long serialVersionUID = 3905804162787980599L;
    protected TypeInfo componentType;
    protected int hash = -1;

    public ArrayInfoImpl() {
    }

    public ArrayInfoImpl(TypeInfo componentType) {
        this.componentType = componentType;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        TypeInfo temp = componentType;
        while (temp.isArray()) {
            builder.append("[");
            temp = ((ArrayInfo)temp).getComponentType();
        }
        if (temp.getClass().equals(PrimitiveInfo.class)) {
            builder.append(temp.getName());
        } else {
            builder.append("L").append(temp.getName()).append(";");
        }
        this.name = builder.toString();
        this.calculateHash();
    }

    public TypeInfo getComponentType() {
        return this.componentType;
    }

    public AnnotationValue getAnnotation(String name) {
        return null;
    }

    public AnnotationValue[] getAnnotations() {
        return UNKNOWN_ANNOTATIONS;
    }

    public boolean isAnnotationPresent(String name) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayInfo)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayInfo arrayInfo = (ArrayInfo)o;
        return this.componentType.equals(arrayInfo.getComponentType());
    }

    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int result = super.hashCode();
        this.hash = result = 29 * result + this.componentType.hashCode();
    }
}

