/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jboss.reflect.spi.AbstractValue;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.Value;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationValueImpl
extends AbstractValue
implements AnnotationValue {
    private static final long serialVersionUID = 3257290210164289843L;
    protected AnnotationInfo annotationType;
    protected HashMap<String, Value> attributeValues;
    protected Annotation underlying;
    protected int hash = -1;

    public AnnotationValueImpl() {
    }

    @Deprecated
    public AnnotationValueImpl(AnnotationInfo annotationType, HashMap<String, Value> attributeValues) {
        this(annotationType, attributeValues, null);
    }

    public AnnotationValueImpl(AnnotationInfo annotationType, HashMap<String, Value> attributeValues, Annotation underlying) {
        if (annotationType == null) {
            throw new IllegalArgumentException("Null annotationType");
        }
        if (attributeValues == null) {
            throw new IllegalArgumentException("Null attribute values");
        }
        this.annotationType = annotationType;
        this.attributeValues = attributeValues;
        this.underlying = underlying;
        this.calculateHash();
    }

    @Override
    public boolean isAnnotation() {
        return true;
    }

    @Override
    public AnnotationInfo getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public Value getValue(String attributeName) {
        return this.attributeValues.get(attributeName);
    }

    @Override
    public Map<String, Value> getValues() {
        return this.attributeValues;
    }

    @Override
    public TypeInfo getType() {
        return this.annotationType;
    }

    @Override
    public Annotation getUnderlyingAnnotation() {
        return this.underlying;
    }

    @Override
    public <T extends Annotation> T getUnderlyingAnnotation(Class<T> annotationType) {
        return (T)((Annotation)annotationType.cast(this.underlying));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AnnotationValue)) {
            return false;
        }
        AnnotationValue annotationValue = (AnnotationValue)o;
        if (!this.annotationType.equals(annotationValue.getAnnotationType())) {
            return false;
        }
        if (!this.attributeValues.equals(annotationValue.getValues())) {
            return false;
        }
        Annotation otherUnderlying = annotationValue.getUnderlyingAnnotation();
        if (this.underlying == null && otherUnderlying != null) {
            return false;
        }
        if (this.underlying != null && otherUnderlying == null) {
            return false;
        }
        return ((Object)this.underlying).equals(otherUnderlying);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int result = this.annotationType != null ? this.annotationType.hashCode() : 0;
        this.hash = result = 29 * result + this.attributeValues.hashCode();
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.annotationType.getName());
    }

    @Override
    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.annotationType.getName());
        if (this.attributeValues != null && this.attributeValues.size() > 0) {
            buffer.append(" values=").append(this.attributeValues);
        }
    }
}

