/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.naming.Util;

public class JndiBinder {
    private String bindTo;
    private Object target;
    private boolean serializable;
    private Hashtable properties;

    public void setBindTo(String bindTo) {
        this.bindTo = bindTo;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    public void setJndiProperties(Hashtable properties) {
        this.properties = properties;
    }

    public void start() throws Exception {
        InitialContext ctx1 = null;
        ctx1 = this.properties != null ? new InitialContext(this.properties) : new InitialContext();
        InitialContext ctx = ctx1;
        try {
            if (this.serializable) {
                Util.rebind((Context)ctx, this.bindTo, this.target);
            } else {
                NonSerializableFactory.rebind(ctx, this.bindTo, this.target);
            }
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind JndiBinder service into JNDI under jndiName:" + ctx.getNameInNamespace() + "/" + this.bindTo);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        InitialContext ctx1 = null;
        ctx1 = this.properties != null ? new InitialContext(this.properties) : new InitialContext();
        InitialContext ctx = ctx1;
        if (this.serializable) {
            Util.unbind((Context)ctx, this.bindTo);
        } else {
            NonSerializableFactory.unbind(this.bindTo);
        }
    }
}

