/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.mxbean;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.DynamicMBean;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.jboss.mx.mxbean.CompositeDataInvocationHandler;
import org.jboss.mx.mxbean.CompositeTypeMetaDataFactory;
import org.jboss.mx.mxbean.MXBeanDelegate;
import org.jboss.util.collection.WeakValueHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXBeanUtils {
    private static final Map<Method, String> compositeDataKeyCache = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class, Map<String, Method>> compositeDataMethodCache = Collections.synchronizedMap(new WeakHashMap());
    public static final String MAP_KEY = "key";
    public static final String MAP_VALUE = "value";
    public static final String[] MAP_INDEX_NAMES = new String[]{"key"};
    public static final String[] MAP_ITEM_NAMES = new String[]{"key", "value"};

    public static OpenType getOpenType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        OpenType result = MXBeanUtils.checkType(type);
        if (result != null) {
            return result;
        }
        Class clazz = (Class)type;
        return CompositeTypeMetaDataFactory.getCompositeType(clazz);
    }

    public static SimpleType getSimpleType(Class type) throws Exception {
        SimpleType simpleType = MXBeanUtils.checkSimpleType(type);
        if (simpleType == null) {
            throw new IllegalArgumentException("Not a SimpleType: " + type.getName());
        }
        return simpleType;
    }

    public static OpenType checkType(Type type) {
        OpenType result = MXBeanUtils.checkSimpleType(type);
        if (result != null) {
            return result;
        }
        result = MXBeanUtils.checkEnum(type);
        if (result != null) {
            return result;
        }
        result = MXBeanUtils.checkArray(type);
        if (result != null) {
            return result;
        }
        result = MXBeanUtils.checkCollection(type);
        if (result != null) {
            return result;
        }
        return MXBeanUtils.checkMap(type);
    }

    public static <T> T createCompositeDataProxy(Class<T> intf, CompositeData compositeData) {
        if (intf == null) {
            throw new IllegalArgumentException("Null interface");
        }
        CompositeDataInvocationHandler handler = new CompositeDataInvocationHandler(compositeData);
        Object object = Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)handler);
        return intf.cast(object);
    }

    public static Object construct(Type type, Object value, Object context) throws Exception {
        OpenType openType = MXBeanUtils.getOpenType(type);
        return MXBeanUtils.construct(openType, value, context);
    }

    public static Object construct(OpenType openType, Object value, Object context) throws Exception {
        if (openType instanceof SimpleType) {
            return MXBeanUtils.constructSimpleData(value);
        }
        if (openType.isArray()) {
            return MXBeanUtils.constructArrayData(openType, value, context);
        }
        if (openType instanceof TabularType) {
            return MXBeanUtils.constructTabularData(openType, value, context);
        }
        return MXBeanUtils.constructCompositeData(openType, value, context);
    }

    public static Object reconstruct(Type type, Object value, Object context) throws Exception {
        OpenType openType = MXBeanUtils.getOpenType(type);
        return MXBeanUtils.reconstruct(openType, type, value, context);
    }

    public static Object reconstruct(OpenType openType, Type type, Object value, Object context) throws Exception {
        if (openType instanceof SimpleType) {
            return MXBeanUtils.reconstructSimpleData(type, value, context);
        }
        if (openType.isArray()) {
            return MXBeanUtils.reconstructArrayData(openType, type, value, context);
        }
        if (openType instanceof TabularType) {
            return MXBeanUtils.reconstructTabularData(openType, type, value, context);
        }
        return MXBeanUtils.reconstructCompositeData(openType, type, value, context);
    }

    public static SimpleType checkSimpleType(Type type) {
        if (BigDecimal.class.equals((Object)type)) {
            return SimpleType.BIGDECIMAL;
        }
        if (BigInteger.class.equals((Object)type)) {
            return SimpleType.BIGINTEGER;
        }
        if (Boolean.class.equals((Object)type)) {
            return SimpleType.BOOLEAN;
        }
        if (Boolean.TYPE.equals(type)) {
            return SimpleType.BOOLEAN;
        }
        if (Byte.class.equals((Object)type)) {
            return SimpleType.BYTE;
        }
        if (Byte.TYPE.equals(type)) {
            return SimpleType.BYTE;
        }
        if (Character.class.equals((Object)type)) {
            return SimpleType.CHARACTER;
        }
        if (Character.TYPE.equals(type)) {
            return SimpleType.CHARACTER;
        }
        if (Date.class.equals((Object)type)) {
            return SimpleType.DATE;
        }
        if (Double.class.equals((Object)type)) {
            return SimpleType.DOUBLE;
        }
        if (Double.TYPE.equals(type)) {
            return SimpleType.DOUBLE;
        }
        if (Float.class.equals((Object)type)) {
            return SimpleType.FLOAT;
        }
        if (Float.TYPE.equals(type)) {
            return SimpleType.FLOAT;
        }
        if (Integer.class.equals((Object)type)) {
            return SimpleType.INTEGER;
        }
        if (Integer.TYPE.equals(type)) {
            return SimpleType.INTEGER;
        }
        if (Long.class.equals((Object)type)) {
            return SimpleType.LONG;
        }
        if (Long.TYPE.equals(type)) {
            return SimpleType.LONG;
        }
        if (ObjectName.class.equals((Object)type)) {
            return SimpleType.OBJECTNAME;
        }
        if (Short.class.equals((Object)type)) {
            return SimpleType.SHORT;
        }
        if (Short.TYPE.equals(type)) {
            return SimpleType.SHORT;
        }
        if (String.class.equals((Object)type)) {
            return SimpleType.STRING;
        }
        if (Void.class.equals((Object)type)) {
            return SimpleType.VOID;
        }
        return null;
    }

    public static SimpleType checkEnum(Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class clazz = (Class)type;
        if (clazz.isEnum() || Enum.class.equals((Object)clazz)) {
            return SimpleType.STRING;
        }
        return null;
    }

    public static Object constructSimpleData(Object value) {
        if (value != null && value instanceof Enum) {
            Enum enumeration = (Enum)value;
            return enumeration.name();
        }
        return value;
    }

    private static Object reconstructSimpleData(Type type, Object value, Object context) {
        if (type instanceof Class) {
            if (value != null) {
                Class clazz = (Class)type;
                if (clazz.isEnum() || Enum.class.equals((Object)clazz)) {
                    String string = (String)value;
                    return Enum.valueOf(clazz, string);
                }
            } else {
                Class clazz = (Class)type;
                if (clazz.isPrimitive()) {
                    throw new IllegalArgumentException("Attempt to use null as a primitive for: " + context);
                }
                return null;
            }
        }
        return value;
    }

    public static ArrayType checkArray(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (!clazz.isArray()) {
                return null;
            }
            int dimension = 1;
            Class<?> componentType = clazz.getComponentType();
            while (componentType.isArray()) {
                ++dimension;
                componentType = componentType.getComponentType();
            }
            OpenType componentOpenType = MXBeanUtils.getOpenType(componentType);
            try {
                return new ArrayType(dimension, componentOpenType);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            int dimension = 1;
            Type componentType = arrayType.getGenericComponentType();
            while (componentType instanceof GenericArrayType) {
                ++dimension;
                arrayType = (GenericArrayType)componentType;
                componentType = arrayType.getGenericComponentType();
            }
            OpenType componentOpenType = MXBeanUtils.getOpenType(componentType);
            try {
                return new ArrayType(dimension, componentOpenType);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static ArrayType checkCollection(Type type) {
        if (!(type instanceof ParameterizedType)) {
            if (type instanceof Class) {
                return MXBeanUtils.checkCollectionClass((Class)type);
            }
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            return null;
        }
        Class rawClass = (Class)rawType;
        if (!Collection.class.isAssignableFrom(rawClass)) {
            return null;
        }
        Type componentType = parameterizedType.getActualTypeArguments()[0];
        OpenType componentOpenType = MXBeanUtils.getOpenType(componentType);
        try {
            return new ArrayType(1, componentOpenType);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ArrayType checkCollectionClass(Class clazz) {
        if (!Collection.class.isAssignableFrom(clazz)) {
            return null;
        }
        OpenType componentOpenType = MXBeanUtils.getOpenType(Object.class);
        try {
            return new ArrayType(1, componentOpenType);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object constructArrayData(OpenType openType, Object value, Object context) throws Exception {
        if (value == null) {
            return null;
        }
        ArrayType arrayType = (ArrayType)openType;
        OpenType elementType = arrayType.getElementOpenType();
        int dimension = arrayType.getDimension();
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            Object[] oldArray = (Object[])value;
            Class<?> componentType = Class.forName(arrayType.getClassName());
            return MXBeanUtils.constructArray(elementType, componentType.getComponentType(), dimension, oldArray, context);
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            Object[] oldArray = c.toArray();
            Class<?> componentType = Class.forName(arrayType.getClassName());
            return MXBeanUtils.constructArray(elementType, componentType.getComponentType(), dimension, oldArray, context);
        }
        throw new UnsupportedOperationException("Cannot construct array for: " + value);
    }

    private static Object[] constructArray(OpenType elementType, Class<?> componentType, int dimension, Object[] oldArray, Object context) throws Exception {
        if (oldArray == null) {
            return null;
        }
        Object[] newArray = (Object[])Array.newInstance(componentType, oldArray.length);
        if (dimension > 1) {
            for (int i = 0; i < oldArray.length; ++i) {
                Object[] nestedOld = (Object[])oldArray[i];
                newArray[i] = MXBeanUtils.constructArray(elementType, componentType.getComponentType(), dimension - 1, nestedOld, context);
            }
        } else if (Object.class.equals(componentType)) {
            for (int i = 0; i < oldArray.length; ++i) {
                newArray[i] = oldArray[i];
            }
        } else {
            for (int i = 0; i < oldArray.length; ++i) {
                newArray[i] = MXBeanUtils.construct(elementType, oldArray[i], context);
            }
        }
        return newArray;
    }

    public static Object reconstructArrayData(OpenType openType, Type type, Object value, Object context) throws Exception {
        ParameterizedType parameterizedType;
        Type rawType;
        if (value == null) {
            return null;
        }
        ArrayType arrayType = (ArrayType)MXBeanUtils.getOpenType(type);
        OpenType elementType = arrayType.getElementOpenType();
        int dimension = arrayType.getDimension();
        Object[] oldArray = (Object[])value;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return MXBeanUtils.reconstructArray(elementType, clazz.getComponentType(), dimension, oldArray, context);
            }
        } else if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class raw = (Class)rawType;
            if (Set.class.isAssignableFrom(raw)) {
                return MXBeanUtils.createSet(oldArray);
            }
            if (Collection.class.isAssignableFrom(raw)) {
                return MXBeanUtils.createCollection(oldArray);
            }
        }
        throw new UnsupportedOperationException("Cannot convert array type: " + type);
    }

    private static Object[] reconstructArray(OpenType elementType, Class componentType, int dimension, Object[] oldArray, Object context) throws Exception {
        if (oldArray == null) {
            return null;
        }
        Object[] newArray = (Object[])Array.newInstance(componentType, oldArray.length);
        if (dimension > 1) {
            for (int i = 0; i < oldArray.length; ++i) {
                Object[] nestedOld = (Object[])oldArray[i];
                newArray[i] = MXBeanUtils.reconstructArray(elementType, componentType.getComponentType(), dimension - 1, nestedOld, context);
            }
        } else {
            for (int i = 0; i < oldArray.length; ++i) {
                newArray[i] = MXBeanUtils.reconstruct(elementType, componentType, oldArray[i], context);
            }
        }
        return newArray;
    }

    private static Collection createCollection(Object[] array) {
        return Arrays.asList(array);
    }

    private static Set createSet(Object[] array) {
        HashSet<Object> result = new HashSet<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    public static TabularType checkMap(Type type) {
        if (!(type instanceof ParameterizedType)) {
            if (type instanceof Class) {
                return MXBeanUtils.checkMapClass((Class)type);
            }
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            return null;
        }
        Class rawClass = (Class)rawType;
        if (!Map.class.isAssignableFrom(rawClass)) {
            return null;
        }
        Type[] args = parameterizedType.getActualTypeArguments();
        Type keyType = args[0];
        Type valueType = args[1];
        return MXBeanUtils.createMapType(keyType, valueType);
    }

    public static TabularType checkMapClass(Class clazz) {
        if (!Map.class.isAssignableFrom(clazz)) {
            return null;
        }
        return MXBeanUtils.createMapType(Object.class, Object.class);
    }

    public static TabularType createMapType(Type keyType, Type valueType) {
        String name = Map.class.getName();
        OpenType[] itemTypes = new OpenType[]{MXBeanUtils.getOpenType(keyType), MXBeanUtils.getOpenType(valueType)};
        try {
            CompositeType entryType = MXBeanUtils.createMapEntryType(itemTypes);
            return new TabularType(name, name, entryType, MAP_INDEX_NAMES);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static CompositeType createMapEntryType(OpenType[] itemTypes) {
        String entryName = Map.Entry.class.getName();
        try {
            return new CompositeType(entryName, entryName, MAP_ITEM_NAMES, MAP_ITEM_NAMES, itemTypes);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object constructTabularData(OpenType openType, Object value, Object context) throws Exception {
        if (value == null) {
            return null;
        }
        TabularType tabularType = (TabularType)openType;
        if (value instanceof Map) {
            TabularDataSupport table = new TabularDataSupport(tabularType);
            CompositeType entryType = tabularType.getRowType();
            OpenType keyType = entryType.getType(MAP_KEY);
            OpenType valueType = entryType.getType(MAP_VALUE);
            Map m = (Map)value;
            for (Map.Entry entry : m.entrySet()) {
                Object key = MXBeanUtils.construct(keyType, entry.getKey(), context);
                Object val = MXBeanUtils.construct(valueType, entry.getValue(), context);
                CompositeDataSupport data = new CompositeDataSupport(entryType, MAP_ITEM_NAMES, new Object[]{key, val});
                table.put(data);
            }
            return table;
        }
        throw new UnsupportedOperationException("Cannot construct map for: " + value);
    }

    public static Object reconstructTabularData(OpenType openType, Type type, Object value, Object context) throws Exception {
        Class raw;
        ParameterizedType parameterizedType;
        Type rawType;
        if (value == null) {
            return null;
        }
        TabularType tabularType = (TabularType)MXBeanUtils.getOpenType(type);
        if (!(type instanceof Class) && type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class && Map.class.isAssignableFrom(raw = (Class)rawType)) {
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            return MXBeanUtils.createMap(tabularType, keyType, valueType, value, context);
        }
        throw new UnsupportedOperationException("Cannot convert array type: " + type);
    }

    private static Map createMap(TabularType openType, Type keyType, Type valueType, Object value, Object context) throws Exception {
        if (value == null) {
            return null;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        TabularData table = (TabularData)value;
        Collection values = table.values();
        for (CompositeData entry : values) {
            Object key = MXBeanUtils.reconstruct(keyType, entry.get(MAP_KEY), context);
            Object val = MXBeanUtils.reconstruct(valueType, entry.get(MAP_VALUE), context);
            result.put(key, val);
        }
        return result;
    }

    public static Object constructCompositeData(OpenType openType, Object value, Object context) throws Exception {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        CompositeType compositeType = (CompositeType)openType;
        Set nameSet = compositeType.keySet();
        String[] names = nameSet.toArray(new String[nameSet.size()]);
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name;
            OpenType itemType = compositeType.getType(name = names[i]);
            Method method = MXBeanUtils.getCompositeDataMethod(clazz, name, itemType == SimpleType.BOOLEAN);
            Object itemValue = method.invoke(value, null);
            values[i] = MXBeanUtils.construct(itemType, itemValue, context);
        }
        return new CompositeDataSupport(compositeType, names, values);
    }

    public static Object reconstructCompositeData(OpenType openType, Type type, Object value, Object context) throws Exception {
        if (value == null) {
            return null;
        }
        CompositeData compositeData = (CompositeData)value;
        CompositeDataInvocationHandler handler = new CompositeDataInvocationHandler(compositeData);
        Class clazz = (Class)type;
        Class<Object>[] interfaces = null;
        interfaces = clazz.isInterface() ? new Class[]{clazz} : clazz.getInterfaces();
        return Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    public static String getCompositeDataKey(Method method) {
        String key = compositeDataKeyCache.get(method);
        if (key != null) {
            return key;
        }
        StringBuilder fieldName = null;
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (!Void.TYPE.equals(returnType) && paramTypes.length == 0) {
            String name = method.getName();
            if (name.startsWith("is") && name.length() > 2) {
                if (Boolean.TYPE.equals(returnType)) {
                    fieldName = new StringBuilder();
                    fieldName.append(Character.toLowerCase(name.charAt(2)));
                    if (name.length() > 3) {
                        fieldName.append(name.substring(3));
                    }
                }
            } else if (name.startsWith("get") && name.length() > 3) {
                fieldName = new StringBuilder();
                fieldName.append(Character.toLowerCase(name.charAt(3)));
                if (name.length() > 4) {
                    fieldName.append(name.substring(4));
                }
            }
        }
        if (fieldName == null) {
            return null;
        }
        String result = fieldName.toString();
        compositeDataKeyCache.put(method, result);
        return result;
    }

    public static Method getCompositeDataMethod(Class clazz, String key, boolean isBoolean) throws Exception {
        Method method;
        WeakValueHashMap cache = compositeDataMethodCache.get(clazz);
        if (cache != null && (method = cache.get(key)) != null) {
            return method;
        }
        StringBuilder name = new StringBuilder();
        name.append(Character.toUpperCase(key.charAt(0)));
        if (key.length() > 1) {
            name.append(key.substring(1));
        }
        Method method2 = null;
        try {
            method2 = clazz.getMethod("get" + name, null);
        }
        catch (NoSuchMethodException e) {
            if (isBoolean) {
                try {
                    method2 = clazz.getMethod("is" + name, null);
                }
                catch (NoSuchMethodException ignored) {
                    throw e;
                }
            }
            throw e;
        }
        if (cache == null) {
            cache = new WeakValueHashMap();
            compositeDataMethodCache.put(clazz, cache);
        }
        cache.put(key, method2);
        return method2;
    }

    public static DynamicMBean createMXBean(Object resource, Class<?> mxbeanInterface) {
        try {
            return new MXBeanDelegate(resource, mxbeanInterface);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating MXBean", e);
        }
    }
}

