/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.LoadMgr3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.UnifiedClassLoaderMBean;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.util.loading.Translatable;

public class UnifiedClassLoader
extends RepositoryClassLoader
implements UnifiedClassLoaderMBean,
Translatable {
    private static final Logger log = Logger.getLogger(UnifiedClassLoader.class);
    private ThreadLocal<String> delegatedClassName;
    protected URL url;
    protected URL origURL;

    public UnifiedClassLoader(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader(URL url, URL origURL) {
        this(url, origURL, UnifiedClassLoader.class.getClassLoader());
    }

    public UnifiedClassLoader(URL url, URL origURL, ClassLoader parent) {
        URL[] uRLArray;
        if (url == null) {
            uRLArray = new URL[]{};
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        }
        super(uRLArray, parent);
        this.delegatedClassName = new ThreadLocal();
        this.url = null;
        this.origURL = null;
        if (log.isTraceEnabled()) {
            log.trace("New jmx UCL with url " + url);
        }
        this.url = url;
        this.origURL = origURL;
    }

    public UnifiedClassLoader(URL url, LoaderRepository repository) {
        this(url, null, repository);
    }

    public UnifiedClassLoader(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.setRepository(repository);
        repository.addClassLoader(this);
    }

    public UnifiedClassLoader(URL url, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, null, server, repositoryName);
    }

    public UnifiedClassLoader(URL url, URL origURL, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, origURL);
        LoaderRepository rep = (LoaderRepository)server.invoke(repositoryName, "registerClassLoader", new Object[]{this}, new String[]{this.getClass().getName()});
        this.setRepository(rep);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        String name = "jmx.loading:UCL=" + Integer.toHexString(super.hashCode());
        return new ObjectName(name);
    }

    public void unregister() {
        super.unregister();
        this.origURL = null;
        this.url = null;
    }

    public URL getURL() {
        return this.url;
    }

    public URL getOrigURL() {
        return this.origURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Class loadClassImpl(String name, boolean resolve, int stopAt) throws ClassNotFoundException {
        ClassLoadingTask task;
        block24: {
            ++this.loadClassDepth;
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace("loadClassImpl, name=" + name + ", resolve=" + resolve);
            }
            if (this.repository == null) {
                try {
                    String prevName = this.delegatedClassName.get();
                    if (prevName != null && prevName.equals(name)) {
                        throw new ClassNotFoundException("Recursing on: " + name);
                    }
                    this.delegatedClassName.set(name);
                    Class clazz = super.loadClass(name, resolve);
                    return clazz;
                }
                catch (ClassNotFoundException ignored) {
                }
                finally {
                    this.delegatedClassName.set(null);
                }
                String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
                throw new ClassNotFoundException(msg, this.unregisterTrace);
            }
            boolean acquired = this.attempt(1L);
            while (!acquired) {
                try {
                    if (trace) {
                        log.trace("Waiting for loadClass lock");
                    }
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                acquired = this.attempt(1L);
            }
            task = null;
            try {
                UnifiedLoaderRepository3 ulr3;
                Thread t = Thread.currentThread();
                if (this.loadLock.holds() == 1L) {
                    LoadMgr3.registerLoaderThread(this, t);
                }
                if (LoadMgr3.beginLoadTask(task = new ClassLoadingTask(name, this, t, stopAt), ulr3 = (UnifiedLoaderRepository3)this.repository)) break block24;
                while (task.threadTaskCount != 0) {
                    try {
                        LoadMgr3.nextTask(t, task, ulr3);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.loadLock.holds() == 1L) {
                    LoadMgr3.endLoadTask(task);
                }
                this.release();
                this.notifyAll();
                --this.loadClassDepth;
                throw throwable;
            }
        }
        if (this.loadLock.holds() == 1L) {
            LoadMgr3.endLoadTask(task);
        }
        this.release();
        this.notifyAll();
        --this.loadClassDepth;
        if (task.loadedClass != null) return task.loadedClass;
        if (task.loadException instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)task.loadException;
        }
        if (task.loadException instanceof NoClassDefFoundError) {
            throw (NoClassDefFoundError)task.loadException;
        }
        if (task.loadException == null) throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
        if (log.isTraceEnabled()) {
            log.trace("Unexpected error during load of:" + name, task.loadException);
        }
        String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
        ClassNotFoundException cnfe = new ClassNotFoundException(msg, task.loadException);
        throw cnfe;
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        CodeSource permCS = cs;
        if (this.origURL != null) {
            permCS = new CodeSource(this.origURL, cs.getCertificates());
        }
        Policy policy = Policy.getPolicy();
        PermissionCollection perms = super.getPermissions(permCS);
        PermissionCollection perms2 = super.getPermissions(cs);
        PermissionCollection perms3 = policy.getPermissions(permCS);
        Enumeration<Permission> iter = perms2.elements();
        while (iter.hasMoreElements()) {
            perms.add(iter.nextElement());
        }
        iter = perms3.elements();
        while (iter.hasMoreElements()) {
            perms.add(iter.nextElement());
        }
        if (log.isTraceEnabled()) {
            log.trace("getPermissions, url=" + this.url + ", origURL=" + this.origURL + " -> " + perms);
        }
        return perms;
    }

    protected ProtectionDomain getProtectionDomain() {
        return this.getProtectionDomain(this.origURL != null ? this.origURL : this.url);
    }
}

