/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.jboss.classloading.spi.ClassLoadingDomain;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.classloading.spi.Translator;
import org.jboss.logging.Logger;
import org.jboss.mx.server.ServerConstants;

public abstract class LoaderRepositoryDomain
implements ServerConstants,
ClassLoadingDomain {
    protected static Vector loaders = new Vector();
    protected static LoaderRepositoryDomain instance = null;
    protected Translator translator = null;
    private ConcurrentReaderHashMap classes = new ConcurrentReaderHashMap();
    private static HashMap nativeClassBySignature;
    private static final Logger log;

    public Vector getLoaders() {
        return loaders;
    }

    public URL[] getURLs() {
        return null;
    }

    public Class getCachedClass(String classname) {
        return (Class)this.classes.get((Object)classname);
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator t) {
        this.translator = t;
    }

    public int compare(LoaderRepositoryDomain lr) {
        if (lr == this) {
            return 0;
        }
        return 1;
    }

    public abstract Class loadClass(String var1) throws ClassNotFoundException;

    public abstract Class loadClass(String var1, boolean var2, DomainClassLoader var3) throws ClassNotFoundException;

    public abstract DomainClassLoader newClassLoader(URL var1, boolean var2) throws Exception;

    public abstract DomainClassLoader newClassLoader(URL var1, URL var2, boolean var3) throws Exception;

    public abstract URL getResource(String var1, DomainClassLoader var2);

    public abstract void getResources(String var1, DomainClassLoader var2, List var3);

    public abstract void addClassLoader(DomainClassLoader var1);

    public abstract boolean addClassLoaderURL(DomainClassLoader var1, URL var2);

    public abstract void removeClassLoader(DomainClassLoader var1);

    public static final Class getNativeClassForName(String className) {
        return (Class)nativeClassBySignature.get(className);
    }

    protected int reverseCompare(LoaderRepositoryDomain lr) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheLoadedClass(String name, Class cls, DomainClassLoader cl) {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            this.classes.put((Object)name, (Object)cls);
            if (log.isTraceEnabled()) {
                log.trace("cacheLoadedClass, classname: " + name + ", class: " + cls + ", cl: " + cl);
            }
        }
    }

    void clear() {
        this.classes.clear();
    }

    static {
        log = Logger.getLogger(LoaderRepositoryDomain.class);
        nativeClassBySignature = new HashMap();
        nativeClassBySignature.put("boolean", Boolean.TYPE);
        nativeClassBySignature.put("byte", Byte.TYPE);
        nativeClassBySignature.put("char", Character.TYPE);
        nativeClassBySignature.put("double", Double.TYPE);
        nativeClassBySignature.put("float", Float.TYPE);
        nativeClassBySignature.put("int", Integer.TYPE);
        nativeClassBySignature.put("long", Long.TYPE);
        nativeClassBySignature.put("short", Short.TYPE);
        nativeClassBySignature.put("void", Void.TYPE);
        nativeClassBySignature.put("boolean[]", boolean[].class);
        nativeClassBySignature.put("byte[]", byte[].class);
        nativeClassBySignature.put("char[]", char[].class);
        nativeClassBySignature.put("double[]", double[].class);
        nativeClassBySignature.put("float[]", float[].class);
        nativeClassBySignature.put("int[]", int[].class);
        nativeClassBySignature.put("long[]", long[].class);
        nativeClassBySignature.put("short[]", short[].class);
    }
}

