/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMetaType<T extends Serializable>
extends AbstractMetaType<T> {
    private static final long serialVersionUID = 6786422588217893696L;
    private transient int cachedHashCode = this.getClassName().hashCode();
    private transient String cachedToString;
    public static final SimpleMetaType<BigDecimal> BIGDECIMAL = new SimpleMetaType(BigDecimal.class.getName());
    public static final SimpleMetaType<BigInteger> BIGINTEGER = new SimpleMetaType(BigInteger.class.getName());
    public static final SimpleMetaType<Boolean> BOOLEAN = new SimpleMetaType(Boolean.class.getName());
    public static final SimpleMetaType<Byte> BYTE = new SimpleMetaType(Byte.class.getName());
    public static final SimpleMetaType<Character> CHARACTER = new SimpleMetaType(Character.class.getName());
    public static final SimpleMetaType<Date> DATE = new SimpleMetaType(Date.class.getName());
    public static final SimpleMetaType<Double> DOUBLE = new SimpleMetaType(Double.class.getName());
    public static final SimpleMetaType<Float> FLOAT = new SimpleMetaType(Float.class.getName());
    public static final SimpleMetaType<Integer> INTEGER = new SimpleMetaType(Integer.class.getName());
    public static final SimpleMetaType<Long> LONG = new SimpleMetaType(Long.class.getName());
    public static final SimpleMetaType<Short> SHORT = new SimpleMetaType(Short.class.getName());
    public static final SimpleMetaType<String> STRING = new SimpleMetaType(String.class.getName());
    public static final SimpleMetaType VOID = new SimpleMetaType(Void.class.getName());

    public static SimpleMetaType resolve(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (className.equals(STRING.getClassName())) {
            return STRING;
        }
        if (className.equals(INTEGER.getClassName())) {
            return INTEGER;
        }
        if (className.equals(BOOLEAN.getClassName())) {
            return BOOLEAN;
        }
        if (className.equals(LONG.getClassName())) {
            return LONG;
        }
        if (className.equals(BYTE.getClassName())) {
            return BYTE;
        }
        if (className.equals(CHARACTER.getClassName())) {
            return CHARACTER;
        }
        if (className.equals(DOUBLE.getClassName())) {
            return DOUBLE;
        }
        if (className.equals(FLOAT.getClassName())) {
            return FLOAT;
        }
        if (className.equals(SHORT.getClassName())) {
            return SHORT;
        }
        if (className.equals(BIGDECIMAL.getClassName())) {
            return BIGDECIMAL;
        }
        if (className.equals(BIGINTEGER.getClassName())) {
            return BIGINTEGER;
        }
        if (className.equals(VOID.getClassName())) {
            return VOID;
        }
        if (className.equals(DATE.getClassName())) {
            return DATE;
        }
        throw new IllegalArgumentException(className);
    }

    private SimpleMetaType(String className) {
        super(className);
        StringBuilder buffer = new StringBuilder(SimpleMetaType.class.getSimpleName());
        buffer.append(":");
        buffer.append(this.getClassName());
        this.cachedToString = buffer.toString();
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof SimpleValue)) {
            return false;
        }
        SimpleValue value = (SimpleValue)obj;
        return this.equals(value.getMetaType());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SimpleMetaType)) {
            return false;
        }
        SimpleMetaType other = (SimpleMetaType)obj;
        return this.getClassName().equals(other.getClassName());
    }

    @Override
    public int hashCode() {
        return this.cachedHashCode;
    }

    @Override
    public String toString() {
        return this.cachedToString;
    }

    private Object readResolve() throws ObjectStreamException {
        return SimpleMetaType.resolve(this.getClassName());
    }
}

