/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.logging.Logger;
import org.jboss.metadata.DDObjectFactory;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.Listener;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDestinationRefMetaData;
import org.jboss.metadata.NameValuePair;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.RunAs;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.WebSecurityMetaData;
import org.jboss.metadata.web.AuthConstraint;
import org.jboss.metadata.web.ErrorPage;
import org.jboss.metadata.web.Filter;
import org.jboss.metadata.web.FilterMapping;
import org.jboss.metadata.web.FormLoginConfig;
import org.jboss.metadata.web.LocaleEncodingMapping;
import org.jboss.metadata.web.LoginConfig;
import org.jboss.metadata.web.MimeMapping;
import org.jboss.metadata.web.ParamValue;
import org.jboss.metadata.web.ReplicationConfig;
import org.jboss.metadata.web.Servlet;
import org.jboss.metadata.web.ServletMapping;
import org.jboss.metadata.web.SessionConfig;
import org.jboss.metadata.web.Taglib;
import org.jboss.metadata.web.UserDataConstraint;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class WebMetaDataObjectFactory
extends DDObjectFactory {
    private static Logger log = Logger.getLogger(WebMetaDataObjectFactory.class);
    private static final ThreadLocal<WebMetaData> activeMetaData = new ThreadLocal();

    public WebMetaData newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        WebMetaData metaData = null;
        metaData = root != null ? (WebMetaData)root : new WebMetaData();
        activeMetaData.set(metaData);
        return metaData;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        activeMetaData.set(null);
        return root;
    }

    public Object newChild(WebMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        log.debug("newChild, " + localName);
        child = this.newEnvRefGroupChild(localName);
        if (child != null) {
            return child;
        }
        if (localName.equals("distributable")) {
            dd.setDistributable(true);
        } else if (localName.equals("context-param")) {
            ParamValue pv = new ParamValue();
            pv.setType(ParamValue.ParamType.CONTEXT_PARAM);
            child = pv;
        } else if (localName.equals("init-param")) {
            ParamValue pv = new ParamValue();
            pv.setType(ParamValue.ParamType.INIT_PARAM);
            child = pv;
        } else if (localName.equals("security-role")) {
            child = new SecurityRoleMetaData();
        } else if (localName.equals("servlet")) {
            child = new Servlet();
        } else if (localName.equals("replication-config")) {
            child = new ReplicationConfig();
        } else if (localName.equals("message-destination")) {
            child = new MessageDestinationMetaData();
        } else if (localName.equals("filter")) {
            child = new Filter();
        } else if (localName.equals("filter-mapping")) {
            child = new FilterMapping();
        } else if (localName.equals("listener")) {
            child = new Listener();
        } else if (localName.equals("servlet-mapping")) {
            child = new ServletMapping();
        } else if (localName.equals("session-config")) {
            dd.gotSessionConfig();
            child = new SessionConfig();
        } else if (localName.equals("error-page")) {
            child = new ErrorPage();
        } else if (localName.equals("security-role")) {
            child = new SecurityRoleMetaData();
        } else if (localName.equals("security-constraint")) {
            child = new WebSecurityMetaData();
        } else if (localName.equals("login-config")) {
            dd.gotLoginConfig();
            child = new LoginConfig();
        } else if (localName.equals("message-destination")) {
            child = new MessageDestinationMetaData();
        } else if (localName.equals("mime-mapping")) {
            child = new MimeMapping();
        } else if (localName.equals("locale-encoding-mapping-list")) {
            child = dd;
        } else if (localName.equals("locale-encoding-mapping")) {
            child = new LocaleEncodingMapping();
        } else if (localName.equals("welcome-file-list")) {
            child = dd;
        } else if (localName.equals("jsp-config")) {
            dd.gotJspConfig();
            child = dd;
        } else if (localName.equals("jsp-property-group")) {
            child = dd;
        } else if (localName.equals("taglib")) {
            child = new Taglib();
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring: " + localName);
        }
        return child;
    }

    public Object newChild(Servlet servlet, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Serializable child = null;
        if (localName.equals("init-param")) {
            child = new NameValuePair();
        } else if (localName.equals("run-as")) {
            child = new RunAs();
        } else if (localName.equals("security-role-ref")) {
            child = new SecurityRoleRefMetaData();
        }
        return child;
    }

    public Object newChild(Filter filter, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        NameValuePair child = null;
        if (localName.equals("init-param")) {
            child = new NameValuePair();
        }
        return child;
    }

    public Object newChild(LoginConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        FormLoginConfig child = null;
        if (localName.equals("form-login-config")) {
            child = new FormLoginConfig();
        }
        return child;
    }

    public Object newChild(WebSecurityMetaData constraint, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Serializable child = null;
        if (localName.equals("web-resource-collection")) {
            child = new WebSecurityMetaData.WebResourceCollection();
        } else if (localName.equals("auth-constraint")) {
            child = new AuthConstraint();
        } else if (localName.equals("user-data-constraint")) {
            child = new UserDataConstraint();
        }
        return child;
    }

    public void addChild(WebMetaData parent, ParamValue pv, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (pv.getType() == ParamValue.ParamType.CONTEXT_PARAM) {
            parent.addContextParam(pv);
        } else if (pv.getType() == ParamValue.ParamType.INIT_PARAM) {
            parent.addInitParam(pv);
        }
    }

    public void addChild(WebMetaData parent, Filter filter, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addFilter(filter);
    }

    public void addChild(WebMetaData parent, FilterMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addFilterMapping(mapping);
    }

    public void addChild(WebMetaData parent, MimeMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addMimeMapping(mapping);
    }

    public void addChild(WebMetaData parent, Taglib taglib, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addTaglib(taglib);
    }

    public void addChild(WebMetaData parent, LocaleEncodingMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addLocaleEncodingMapping(mapping);
    }

    public void addChild(WebMetaData parent, Listener listener, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addListener(listener);
    }

    public void addChild(WebMetaData parent, Servlet servlet, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addServlet(servlet);
        Collection securityRR = servlet.getSecurityRoleRefs();
        if (securityRR != null && securityRR.size() > 0) {
            ArrayList<SecurityRoleRefMetaData> srr = new ArrayList<SecurityRoleRefMetaData>(securityRR);
            parent.addSecurityRoleReference(servlet.getName(), srr);
        }
    }

    public void addChild(WebMetaData parent, ServletMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addServletMapping(mapping);
    }

    public void addChild(WebMetaData parent, SessionConfig config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addSessionConfig(config);
    }

    public void addChild(WebMetaData parent, WebSecurityMetaData constraint, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addSecurityConstraint(constraint);
    }

    public void addChild(WebMetaData parent, ServiceRefMetaData serviceref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addServiceRef(serviceref);
    }

    public void addChild(WebMetaData parent, ErrorPage page, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addErrorPage(page);
    }

    public void addChild(WebMetaData parent, SecurityRoleMetaData role, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addSecurityRole(role);
    }

    public void addChild(WebMetaData parent, EjbLocalRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbLocalRef(ref);
    }

    public void addChild(WebMetaData parent, EjbRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbRef(ref);
    }

    public void addChild(WebMetaData parent, EnvEntryMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEnvEntry(ref);
    }

    public void addChild(WebMetaData parent, MessageDestinationRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addMessageDestinationRef(ref);
    }

    public void addChild(WebMetaData parent, ResourceEnvRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addResourceEnvRef(ref);
    }

    public void addChild(WebMetaData parent, ResourceRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addResourceRef(ref);
    }

    public void addChild(WebMetaData parent, LoginConfig config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setLoginConfig(config);
    }

    public void addChild(WebMetaData parent, MessageDestinationMetaData destination, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addMessageDestination(destination);
    }

    public void addChild(Filter parent, NameValuePair param, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addInitParam(param);
    }

    public void addChild(Servlet parent, NameValuePair param, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addInitParam(param);
    }

    public void addChild(Servlet parent, RunAs runAs, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setRunAs(runAs);
    }

    public void addChild(Servlet parent, SecurityRoleRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addSecurityRoleRef(ref);
    }

    public void addChild(WebSecurityMetaData parent, WebSecurityMetaData.WebResourceCollection collection, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setWebResources(collection);
    }

    public void addChild(WebSecurityMetaData parent, AuthConstraint constraint, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setAuthConstraint(constraint);
    }

    public void addChild(WebSecurityMetaData parent, UserDataConstraint constraint, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setTransportGuarantee(constraint.getTransportGuarantee());
    }

    public void addChild(LoginConfig parent, FormLoginConfig config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setFormLoginConfig(config);
    }

    public void setValue(WebMetaData wmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("description")) {
            wmd.setDescription(value);
        } else if (localName.equals("display-name")) {
            wmd.setDisplayName(value);
        } else if (localName.equals("metadata-complete")) {
            if ("true".equals(value)) {
                wmd.setMetadataComplete(true);
            }
        } else if (localName.equals("welcome-file")) {
            wmd.addWelcomeFile(value);
        } else if (localName.equals("url-pattern")) {
            wmd.addJspMapping(value);
        }
    }

    public void setValue(ParamValue pv, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("description")) {
            pv.setDescription(value);
        } else if (localName.equals("param-name")) {
            pv.setName(value);
        } else if (localName.equals("param-value")) {
            pv.setValue(value);
        }
    }

    public void setValue(Filter filter, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("filter-name")) {
            filter.setName(value);
        } else if (localName.equals("filter-class")) {
            filter.setFilterClass(value);
        }
    }

    public void setValue(FilterMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("filter-name")) {
            mapping.setFilterName(value);
        } else if (localName.equals("url-pattern")) {
            mapping.addUrlPattern(value);
        } else if (localName.equals("servlet-name")) {
            mapping.addServletName(value);
        } else if (localName.equals("dispatcher")) {
            mapping.addDispatcher(value);
        }
    }

    public void setValue(MimeMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("extension")) {
            mapping.setExtension(value);
        } else if (localName.equals("mime-type")) {
            mapping.setMimeType(value);
        }
    }

    public void setValue(Taglib taglib, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("taglib-location")) {
            taglib.setLocation(value);
        } else if (localName.equals("taglib-uri")) {
            taglib.setUri(value);
        }
    }

    public void setValue(LocaleEncodingMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("locale")) {
            mapping.setLocale(value);
        } else if (localName.equals("encoding")) {
            mapping.setEncoding(value);
        }
    }

    public void setValue(ServletMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("servlet-name")) {
            mapping.setName(value);
        } else if (localName.equals("url-pattern")) {
            mapping.addUrlPattern(value);
        }
    }

    public void setValue(ErrorPage page, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("error-code")) {
            page.setErrorCode(value);
        } else if (localName.equals("location")) {
            page.setLocation(value);
        } else if (localName.equals("exception-type")) {
            page.setExceptionType(value);
        }
    }

    public void setValue(SessionConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("session-timeout")) {
            config.setSessionTimeout(value);
        }
    }

    public void setValue(NameValuePair param, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("param-name")) {
            param.setName(value);
        } else if (localName.equals("param-value")) {
            param.setValue(value);
        }
    }

    public void setValue(WebSecurityMetaData.WebResourceCollection collection, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("web-resource-name")) {
            collection.setName(value);
        } else if (localName.equals("http-method")) {
            collection.addHttpMethod(value);
        } else if (localName.equals("url-pattern")) {
            collection.addPattern(value);
        }
    }

    public void setValue(AuthConstraint contraint, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("role-name")) {
            contraint.addRoleName(value);
        }
    }

    public void setValue(SecurityRoleRefMetaData roleRef, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("role-name")) {
            roleRef.setName(value);
        } else if (localName.equals("role-link")) {
            roleRef.setLink(value);
        }
    }

    public void setValue(UserDataConstraint contraint, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("transport-guarantee")) {
            contraint.setTransportGuarantee(value);
        }
    }

    public void setValue(LoginConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("auth-method")) {
            config.setAuthMethod(value);
        } else if (localName.equals("realm-name")) {
            config.setRealmName(value);
        }
    }

    public void setValue(FormLoginConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("form-login-page")) {
            config.setLoginPage(value);
        } else if (localName.equals("form-error-page")) {
            config.setErrorPage(value);
        }
    }

    public void setValue(Servlet servlet, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("servlet-name")) {
            servlet.setName(value);
        } else if (localName.equals("display-name")) {
            servlet.setDisplayName(value);
        } else if (localName.equals("servlet-class")) {
            servlet.setServletClass(value);
        } else if (localName.equals("run-as-principal")) {
            servlet.setRunAsPrincipal(value);
        } else if (localName.equals("jsp-file")) {
            servlet.setJspFile(value);
        } else if (localName.equals("load-on-startup")) {
            int i = Integer.decode(value);
            servlet.setLoadOnStartup(i);
        }
    }
}

