/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class IorSecurityConfigMetaData
implements Serializable {
    private static final long serialVersionUID = -3341898910508715334L;
    private TransportConfig transportConfig;
    private AsContext asContext;
    private SasContext sasContext;

    public IorSecurityConfigMetaData() {
        this.transportConfig = new TransportConfig();
        this.asContext = new AsContext();
        this.sasContext = new SasContext();
    }

    public IorSecurityConfigMetaData(Element element) throws DeploymentException {
        Element child = MetaData.getOptionalChild(element, "transport-config");
        if (child != null) {
            this.transportConfig = new TransportConfig(child);
        }
        if ((child = MetaData.getOptionalChild(element, "as-context")) != null) {
            this.asContext = new AsContext(child);
        }
        if ((child = MetaData.getOptionalChild(element, "sas-context")) != null) {
            this.sasContext = new SasContext(child);
        }
    }

    public TransportConfig getTransportConfig() {
        return this.transportConfig;
    }

    public void setTransportConfig(TransportConfig config) {
        this.transportConfig = config;
    }

    public AsContext getAsContext() {
        return this.asContext;
    }

    public void setAsContext(AsContext context) {
        this.asContext = context;
    }

    public SasContext getSasContext() {
        return this.sasContext;
    }

    public void setSasContext(SasContext context) {
        this.sasContext = context;
    }

    public String toString() {
        return "[transport-config=" + this.transportConfig + ", as-context=" + this.asContext + ", sas-context=" + this.sasContext + "]";
    }

    public static class SasContext {
        public static final String CALLER_PROPAGATION_NONE = "NONE";
        public static final String CALLER_PROPAGATION_SUPPORTED = "SUPPORTED";
        private String callerPropagation;

        public SasContext() {
            this.callerPropagation = CALLER_PROPAGATION_NONE;
        }

        private SasContext(Element element) throws DeploymentException {
            String value = MetaData.getUniqueChildContent(element, "caller-propagation");
            this.setCallerPropagation(value);
        }

        public void setCallerPropagation(String value) {
            if (CALLER_PROPAGATION_NONE.equalsIgnoreCase(value)) {
                this.callerPropagation = CALLER_PROPAGATION_NONE;
            } else if (CALLER_PROPAGATION_SUPPORTED.equalsIgnoreCase(value)) {
                this.callerPropagation = CALLER_PROPAGATION_SUPPORTED;
            } else {
                throw new IllegalStateException("Allowed values for caller-propagation are NONE and SUPPORTED but got " + value);
            }
        }

        public String getCallerPropagation() {
            return this.callerPropagation;
        }

        public boolean isCallerPropagationSupported() {
            return CALLER_PROPAGATION_SUPPORTED.equalsIgnoreCase(this.callerPropagation);
        }

        public String toString() {
            return "[caller-propagation=" + this.callerPropagation + "]";
        }
    }

    public static class AsContext {
        public static final String AUTH_METHOD_USERNAME_PASSWORD = "USERNAME_PASSWORD";
        public static final String AUTH_METHOD_NONE = "NONE";
        private String authMethod;
        private String realm;
        private boolean required;

        public AsContext() {
            this.authMethod = AUTH_METHOD_USERNAME_PASSWORD;
            this.realm = "default";
            this.required = false;
        }

        private AsContext(Element element) throws DeploymentException {
            String value = MetaData.getUniqueChildContent(element, "auth-method");
            this.setAuthMethod(value);
            this.realm = MetaData.getUniqueChildContent(element, "realm");
            if (this.realm == null || this.realm.trim().length() == 0) {
                throw new DeploymentException("realm is not set for ior-security-config/as-context.");
            }
            value = MetaData.getUniqueChildContent(element, "required");
            if ("true".equalsIgnoreCase(value)) {
                this.required = true;
            } else if ("false".equalsIgnoreCase(value)) {
                this.required = false;
            } else {
                throw new DeploymentException("Allowed values for required in ior-security-config/as-context are true and false but got " + value);
            }
        }

        public void setAuthMethod(String value) {
            if (AUTH_METHOD_USERNAME_PASSWORD.equalsIgnoreCase(value)) {
                this.authMethod = AUTH_METHOD_USERNAME_PASSWORD;
            } else if (AUTH_METHOD_NONE.equalsIgnoreCase(value)) {
                this.authMethod = AUTH_METHOD_NONE;
            } else {
                throw new IllegalStateException("The only allowed values for auth-method are USERNAME_PASSWORD, NONE but got " + value);
            }
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public String getRealm() {
            return this.realm;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRealm(String realm) {
            this.realm = realm;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public String toString() {
            return "[auth-method=" + this.authMethod + ", realm=" + this.realm + ", required=" + this.required + "]";
        }
    }

    public static class TransportConfig {
        public static final String INTEGRITY_NONE = "NONE";
        public static final String INTEGRITY_SUPPORTED = "SUPPORTED";
        public static final String INTEGRITY_REQUIRED = "REQUIRED";
        public static final String CONFIDENTIALITY_NONE = "NONE";
        public static final String CONFIDENTIALITY_SUPPORTED = "SUPPORTED";
        public static final String CONFIDENTIALITY_REQUIRED = "REQUIRED";
        public static final String DETECT_MISORDERING_NONE = "NONE";
        public static final String DETECT_MISORDERING_SUPPORTED = "SUPPORTED";
        public static final String DETECT_MISORDERING_REQUIRED = "REQUIRED";
        public static final String DETECT_REPLAY_NONE = "NONE";
        public static final String DETECT_REPLAY_SUPPORTED = "SUPPORTED";
        public static final String DETECT_REPLAY_REQUIRED = "REQUIRED";
        public static final String ESTABLISH_TRUST_IN_TARGET_NONE = "NONE";
        public static final String ESTABLISH_TRUST_IN_TARGET_SUPPORTED = "SUPPORTED";
        public static final String ESTABLISH_TRUST_IN_CLIENT_NONE = "NONE";
        public static final String ESTABLISH_TRUST_IN_CLIENT_SUPPORTED = "SUPPORTED";
        public static final String ESTABLISH_TRUST_IN_CLIENT_REQUIRED = "REQUIRED";
        private String integrity;
        private String confidentiality;
        private String detectMisordering;
        private String detectReplay;
        private String establishTrustInTarget;
        private String establishTrustInClient;

        public TransportConfig() {
            this.integrity = "SUPPORTED";
            this.confidentiality = "SUPPORTED";
            this.establishTrustInTarget = "SUPPORTED";
            this.establishTrustInClient = "SUPPORTED";
            this.detectMisordering = "SUPPORTED";
            this.detectReplay = "SUPPORTED";
        }

        private TransportConfig(Element element) throws DeploymentException {
            String value = MetaData.getUniqueChildContent(element, "integrity");
            this.setIntegrity(value);
            value = MetaData.getUniqueChildContent(element, "confidentiality");
            this.setConfidentiality(value);
            value = MetaData.getUniqueChildContent(element, "establish-trust-in-target");
            this.setEstablishTrustInTarget(value);
            value = MetaData.getUniqueChildContent(element, "establish-trust-in-client");
            this.setEstablishTrustInClient(value);
            value = MetaData.getOptionalChildContent(element, "detect-misordering");
            this.setDetectMisordering(value);
            value = MetaData.getOptionalChildContent(element, "detect-replay");
            this.setDetectReplay(value);
        }

        public void setDetectReplay(String value) {
            this.detectReplay = "NONE".equalsIgnoreCase(value) ? "NONE" : ("REQUIRED".equalsIgnoreCase(value) ? "REQUIRED" : ("SUPPORTED".equalsIgnoreCase(value) ? "SUPPORTED" : "NONE"));
        }

        public void setDetectMisordering(String value) {
            this.detectMisordering = "NONE".equalsIgnoreCase(value) ? "NONE" : ("REQUIRED".equalsIgnoreCase(value) ? "REQUIRED" : ("SUPPORTED".equalsIgnoreCase(value) ? "SUPPORTED" : "NONE"));
        }

        public void setEstablishTrustInClient(String value) {
            if ("NONE".equalsIgnoreCase(value)) {
                this.establishTrustInClient = "NONE";
            } else if ("SUPPORTED".equalsIgnoreCase(value)) {
                this.establishTrustInClient = "SUPPORTED";
            } else if ("REQUIRED".equalsIgnoreCase(value)) {
                this.establishTrustInClient = "REQUIRED";
            } else {
                throw new IllegalStateException("Allowed values for establish-trust-in-client are NONE, SUPPORTED and REQUIRED but got " + value);
            }
        }

        public void setEstablishTrustInTarget(String value) {
            if ("NONE".equalsIgnoreCase(value)) {
                this.establishTrustInTarget = "NONE";
            } else if ("SUPPORTED".equalsIgnoreCase(value)) {
                this.establishTrustInTarget = "SUPPORTED";
            } else {
                throw new IllegalStateException("Allowed values for establish-trust-in-target are NONE and SUPPORTED but got " + value);
            }
        }

        public void setConfidentiality(String value) {
            if ("NONE".equalsIgnoreCase(value)) {
                this.confidentiality = "NONE";
            } else if ("SUPPORTED".equalsIgnoreCase(value)) {
                this.confidentiality = "SUPPORTED";
            } else if ("REQUIRED".equalsIgnoreCase(value)) {
                this.confidentiality = "REQUIRED";
            } else {
                throw new IllegalStateException("Allowed values for confidentiality are NONE, SUPPORTED and REQUIRED but got " + value);
            }
        }

        public void setIntegrity(String value) {
            if ("NONE".equalsIgnoreCase(value)) {
                this.integrity = "NONE";
            } else if ("SUPPORTED".equalsIgnoreCase(value)) {
                this.integrity = "SUPPORTED";
            } else if ("REQUIRED".equalsIgnoreCase(value)) {
                this.integrity = "REQUIRED";
            } else {
                throw new IllegalStateException("Allowed values for integrity element are NONE, REQUIRED and SUPPORTED but got " + value);
            }
        }

        public String getIntegrity() {
            return this.integrity;
        }

        public String getConfidentiality() {
            return this.confidentiality;
        }

        public String getDetectMisordering() {
            return this.detectMisordering;
        }

        public String getDetectReplay() {
            return this.detectReplay;
        }

        public String getEstablishTrustInTarget() {
            return this.establishTrustInTarget;
        }

        public boolean isEstablishTrustInTargetSupported() {
            return "SUPPORTED".equalsIgnoreCase(this.establishTrustInTarget);
        }

        public String getEstablishTrustInClient() {
            return this.establishTrustInClient;
        }

        public String toString() {
            return "[integrity=" + this.integrity + ", confidentiality=" + this.confidentiality + ", establish-trust-in-target=" + this.establishTrustInTarget + ", establish-trust-in-client=" + this.establishTrustInClient + ", detect-misordering=" + this.detectMisordering + ", detect-replay=" + this.detectReplay + "]";
        }
    }
}

