/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.core.plugin.postoffice.cluster.TransactionId;

public class RollbackPullRequest
extends ClusterRequest {
    static final int TYPE = 10;
    private int nodeId;
    private long txId;

    public RollbackPullRequest() {
    }

    RollbackPullRequest(int nodeId, long txId) {
        this.nodeId = nodeId;
        this.txId = txId;
    }

    Object execute(PostOfficeInternal office) throws Throwable {
        office.rollbackTransaction(new TransactionId(this.nodeId, this.txId));
        return null;
    }

    byte getType() {
        return 10;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        this.txId = in.readLong();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        out.writeLong(this.txId);
    }
}

