/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.core.plugin.postoffice.cluster.QueueStats;

class QueueStatsRequest
extends ClusterRequest {
    static final int TYPE = 6;
    private int nodeId;
    private List queueStats;

    QueueStatsRequest() {
    }

    QueueStatsRequest(int nodeId, List stats) {
        this.nodeId = nodeId;
        this.queueStats = stats;
    }

    Object execute(PostOfficeInternal office) throws Exception {
        office.updateQueueStats(this.nodeId, this.queueStats);
        return null;
    }

    byte getType() {
        return 6;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        int size = in.readInt();
        this.queueStats = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            QueueStats stats = new QueueStats();
            stats.read(in);
            this.queueStats.add(stats);
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        out.writeInt(this.queueStats.size());
        Iterator iter = this.queueStats.iterator();
        while (iter.hasNext()) {
            QueueStats stats = (QueueStats)iter.next();
            stats.write(out);
        }
    }
}

