/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.plugin.postoffice.Binding;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterTransaction;
import org.jboss.messaging.core.plugin.postoffice.cluster.LocalClusteredQueue;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.core.plugin.postoffice.cluster.TransactionId;
import org.jboss.messaging.core.plugin.postoffice.cluster.TransactionRequest;

public class PullMessagesRequest
extends TransactionRequest
implements ClusterTransaction {
    private static final Logger log = Logger.getLogger(PullMessagesRequest.class);
    private boolean trace = log.isTraceEnabled();
    private String queueName;
    private int numMessages;
    private Delivery reliableDelivery;
    static final int TYPE = 5;

    PullMessagesRequest() {
    }

    PullMessagesRequest(int nodeId, long txId, long checkChannelID, String queueName, int numMessages) {
        super(nodeId, txId, true, checkChannelID);
        this.queueName = queueName;
        this.numMessages = numMessages;
    }

    PullMessagesRequest(int nodeId, long txId) {
        super(nodeId, txId, false);
    }

    Object execute(PostOfficeInternal office) throws Throwable {
        TransactionId id = new TransactionId(this.nodeId, this.txId);
        if (this.trace) {
            log.trace("Executing PullMessagesRequest with id: " + id + " hold: " + this.hold);
        }
        if (this.hold) {
            Binding binding = office.getBindingForQueueName(this.queueName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for queue: " + this.queueName);
            }
            LocalClusteredQueue queue = (LocalClusteredQueue)binding.getQueue();
            queue.handleGetDeliveriesRequest(this.nodeId, this.numMessages, id, this);
            return null;
        }
        office.commitTransaction(id);
        return null;
    }

    void setReliableDelivery(Delivery del) {
        this.reliableDelivery = del;
    }

    byte getType() {
        return 5;
    }

    public boolean check(PostOfficeInternal office) throws Exception {
        return !office.referenceExistsInStorage(this.checkChannelID, this.reliableDelivery.getReference().getMessage().getMessageID());
    }

    public void commit(PostOfficeInternal office) throws Throwable {
        if (this.trace) {
            log.trace(this + " committing, tx: " + this.txId);
        }
        LocalClusteredQueue queue = (LocalClusteredQueue)this.reliableDelivery.getObserver();
        queue.acknowledgeFromCluster(this.reliableDelivery);
        if (this.trace) {
            log.trace(this + " committed, tx: " + this.txId);
        }
    }

    public void rollback(PostOfficeInternal office) throws Throwable {
        if (this.trace) {
            log.trace(this + " rolling back, tx: " + this.txId);
        }
        this.reliableDelivery.cancel();
        if (this.trace) {
            log.trace(this + " rolled back, tx: " + this.txId);
        }
    }

    public void read(DataInputStream in) throws Exception {
        super.read(in);
        if (this.hold) {
            this.queueName = in.readUTF();
            this.numMessages = in.readInt();
        }
    }

    public void write(DataOutputStream out) throws Exception {
        super.write(out);
        if (this.hold) {
            out.writeUTF(this.queueName);
            out.writeInt(this.numMessages);
        }
    }
}

