/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import org.jboss.messaging.util.Streamable;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

class PostOfficeAddressInfo
implements Streamable,
Serializable {
    private static final long serialVersionUID = 8462102430717730566L;
    private Address syncChannelAddress;
    private Address asyncChannelAddress;

    public PostOfficeAddressInfo() {
    }

    PostOfficeAddressInfo(Address syncChannelAddress, Address asyncChannelAddress) {
        this.syncChannelAddress = syncChannelAddress;
        this.asyncChannelAddress = asyncChannelAddress;
    }

    public void read(DataInputStream in) throws Exception {
        this.syncChannelAddress = new IpAddress();
        this.syncChannelAddress.readFrom(in);
        this.asyncChannelAddress = new IpAddress();
        this.asyncChannelAddress.readFrom(in);
        byte[] byteInput = new byte[in.readInt()];
        in.read(byteInput);
    }

    public void write(DataOutputStream out) throws Exception {
        if (!(this.syncChannelAddress instanceof IpAddress)) {
            throw new IllegalStateException("Address must be IpAddress");
        }
        if (!(this.asyncChannelAddress instanceof IpAddress)) {
            throw new IllegalStateException("Address must be IpAddress");
        }
        this.syncChannelAddress.writeTo(out);
        this.asyncChannelAddress.writeTo(out);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append("synch addr ").append(this.syncChannelAddress);
        sb.append(", asynch addr ").append(this.asyncChannelAddress);
        sb.append("]");
        return sb.toString();
    }

    Address getSyncChannelAddress() {
        return this.syncChannelAddress;
    }

    Address getAsyncChannelAddress() {
        return this.asyncChannelAddress;
    }
}

