/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.MessageFactory;
import org.jboss.messaging.util.StreamUtils;
import org.jboss.messaging.util.Streamable;

class MessageHolder
implements Streamable {
    private String routingKeyText;
    private Message message;
    private Map queueNameToNodeIdMap;

    public MessageHolder() {
    }

    MessageHolder(String routingKeyText, Message message, Map queueNameToNodeIdMap) {
        this.routingKeyText = routingKeyText;
        this.message = message;
        this.queueNameToNodeIdMap = queueNameToNodeIdMap;
    }

    String getRoutingKey() {
        return this.routingKeyText;
    }

    Message getMessage() {
        return this.message;
    }

    Map getQueueNameToNodeIdMap() {
        return this.queueNameToNodeIdMap;
    }

    public void read(DataInputStream in) throws Exception {
        this.routingKeyText = in.readUTF();
        byte type = in.readByte();
        this.message = MessageFactory.createMessage(type);
        this.message.read(in);
        this.queueNameToNodeIdMap = (Map)StreamUtils.readObject(in, false);
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeUTF(this.routingKeyText);
        out.writeByte(this.message.getType());
        this.message.write(out);
        StreamUtils.writeObject(out, this.queueNameToNodeIdMap, true, false);
    }
}

