/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class FailoverStatus
implements Serializable {
    private static final long serialVersionUID = -2668162690753929133L;
    private Set failedOverForNodes = new LinkedHashSet();
    private int currentlyFailingOverForNode;
    private boolean failingOver;
    private boolean failedOver;

    public void startFailingOverForNode(Integer nodeID) {
        if (this.failingOver) {
            throw new IllegalStateException("Already failing over for node " + this.currentlyFailingOverForNode);
        }
        this.failedOverForNodes.remove(nodeID);
        this.currentlyFailingOverForNode = nodeID;
        this.failingOver = true;
        this.failedOver = false;
    }

    public void finishFailingOver() {
        if (!this.failingOver) {
            throw new IllegalStateException("The node is not currently failing over");
        }
        this.failedOverForNodes.add(new Integer(this.currentlyFailingOverForNode));
        this.failingOver = false;
        this.failedOver = true;
    }

    public Set getFailedOverForNodes() {
        return Collections.unmodifiableSet(this.failedOverForNodes);
    }

    public boolean isFailedOverForNode(int nodeId) {
        return this.failedOverForNodes.contains(new Integer(nodeId));
    }

    public boolean isFailingOverForNode(int nodeId) {
        return this.failingOver && this.currentlyFailingOverForNode == nodeId;
    }

    public boolean isFailingOver() {
        return this.failingOver;
    }

    public boolean isFailedOver() {
        return this.failedOver;
    }

    public String toString() {
        return "FailoverStatus[" + this.currentlyFailingOverForNode + "]";
    }
}

