/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin;

import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.jms.selector.SelectorFactory;
import org.jboss.jms.server.JMSConditionFactory;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.messaging.core.plugin.JDBCServiceSupport;
import org.jboss.messaging.core.plugin.contract.MessageStore;
import org.jboss.messaging.core.plugin.contract.MessagingComponent;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.plugin.postoffice.DefaultPostOffice;
import org.jboss.messaging.core.tx.TransactionRepository;

public class DefaultPostOfficeService
extends JDBCServiceSupport {
    private DefaultPostOffice postOffice;
    private ObjectName serverPeerObjectName;
    private String officeName;
    private boolean started;

    public MessagingComponent getInstance() {
        return this.postOffice;
    }

    public synchronized ObjectName getServerPeer() {
        return this.serverPeerObjectName;
    }

    public synchronized void setServerPeer(ObjectName on) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.serverPeerObjectName = on;
    }

    public synchronized String getPostOfficeName() {
        return this.officeName;
    }

    public synchronized void setPostOfficeName(String name) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.officeName = name;
    }

    public String listBindings() {
        return this.postOffice.printBindingInformation();
    }

    protected synchronized void startService() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Service is already started");
        }
        super.startService();
        try {
            TransactionManager tm = this.getTransactionManagerReference();
            ServerPeer serverPeer = (ServerPeer)this.server.getAttribute(this.serverPeerObjectName, "Instance");
            MessageStore ms = serverPeer.getMessageStore();
            PersistenceManager pm = serverPeer.getPersistenceManagerInstance();
            TransactionRepository tr = serverPeer.getTxRepository();
            int nodeId = serverPeer.getServerPeerID();
            SelectorFactory ff = new SelectorFactory();
            JMSConditionFactory cf = new JMSConditionFactory();
            this.postOffice = new DefaultPostOffice(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, nodeId, this.officeName, ms, pm, tr, ff, cf);
            this.postOffice.start();
            this.started = true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    protected void stopService() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service is not started");
        }
        super.stopService();
        try {
            this.postOffice.stop();
            this.postOffice = null;
            this.started = false;
            this.log.debug(this + " stopped");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }
}

