/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.MessageHolder;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.message.SimpleMessageReference;
import org.jboss.messaging.core.plugin.contract.MessageStore;

public class SimpleMessageStore
implements MessageStore {
    private static final Logger log = Logger.getLogger(SimpleMessageStore.class);
    private boolean trace = log.isTraceEnabled();
    private Map messages = new HashMap();

    public SimpleMessageStore() {
        log.debug(this + " initialized");
    }

    public Object getInstance() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageReference reference(Message m) {
        MessageHolder holder;
        SimpleMessageStore simpleMessageStore = this;
        synchronized (simpleMessageStore) {
            holder = (MessageHolder)this.messages.get(new Long(m.getMessageID()));
            if (holder == null) {
                holder = this.addMessage(m);
            }
        }
        holder.incrementInMemoryChannelCount();
        SimpleMessageReference ref = new SimpleMessageReference(holder, this);
        if (this.trace) {
            log.trace(this + " generated " + ref + " for " + m);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageReference reference(long messageID) {
        MessageHolder holder;
        SimpleMessageStore simpleMessageStore = this;
        synchronized (simpleMessageStore) {
            holder = (MessageHolder)this.messages.get(new Long(messageID));
        }
        if (holder == null) {
            return null;
        }
        SimpleMessageReference ref = new SimpleMessageReference(holder, this);
        if (this.trace) {
            log.trace(this + " generates " + ref + " for " + messageID);
        }
        holder.incrementInMemoryChannelCount();
        return ref;
    }

    public boolean forgetMessage(long messageID) {
        return this.messages.remove(new Long(messageID)) != null;
    }

    public int size() {
        return this.messages.size();
    }

    public List messageIds() {
        return new ArrayList(this.messages.keySet());
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public String toString() {
        return "MemoryStore[" + System.identityHashCode(this) + "]";
    }

    protected MessageHolder addMessage(Message m) {
        MessageHolder holder = new MessageHolder(m, this);
        this.messages.put(new Long(m.getMessageID()), holder);
        return holder;
    }
}

