/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractKernelDeployment
extends JBossObject
implements KernelDeployment,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected boolean installed;
    protected transient List<KernelControllerContext> installedContexts = new CopyOnWriteArrayList<KernelControllerContext>();
    protected Boolean scoped;
    protected Set<AnnotationMetaData> annotations;
    protected List<BeanMetaDataFactory> beanFactories;
    protected ClassLoaderMetaData classLoader;

    public void setBeans(List beans) {
        this.beanFactories = beans;
        this.flushJBossObjectCache();
    }

    public void setBeanFactories(List<BeanMetaDataFactory> beanFactories) {
        this.beanFactories = beanFactories;
        this.flushJBossObjectCache();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    @Override
    public void setInstalled(boolean installed) {
        this.installed = installed;
        this.flushJBossObjectCache();
    }

    @Override
    public void addInstalledContext(KernelControllerContext context) {
        this.installedContexts.add(context);
        this.flushJBossObjectCache();
    }

    @Override
    public List<KernelControllerContext> getInstalledContexts() {
        return this.installedContexts;
    }

    @Override
    public void removeInstalledContext(KernelControllerContext context) {
        this.installedContexts.remove(context);
        this.flushJBossObjectCache();
    }

    @Override
    public List<BeanMetaData> getBeans() {
        if (this.beanFactories == null || this.beanFactories.size() == 0) {
            return null;
        }
        ArrayList<BeanMetaData> result = new ArrayList<BeanMetaData>(this.beanFactories.size());
        for (BeanMetaDataFactory factory : this.beanFactories) {
            List<BeanMetaData> beans = factory.getBeans();
            if (this.annotations != null && !this.annotations.isEmpty()) {
                for (BeanMetaData bmd : beans) {
                    Set<AnnotationMetaData> annotationsBMD = bmd.getAnnotations();
                    if (annotationsBMD == null) {
                        annotationsBMD = new HashSet<AnnotationMetaData>();
                        bmd.setAnnotations(annotationsBMD);
                    }
                    annotationsBMD.addAll(this.annotations);
                }
            }
            result.addAll(beans);
        }
        return result;
    }

    @Override
    public Boolean isScoped() {
        return this.scoped;
    }

    public void setScoped(Boolean scoped) {
        this.scoped = scoped;
    }

    @Override
    public Set<AnnotationMetaData> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<AnnotationMetaData> annotations) {
        this.annotations = annotations;
    }

    @Override
    public List<BeanMetaDataFactory> getBeanFactories() {
        return this.beanFactories;
    }

    @Override
    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" installed=").append(this.installed);
        if (this.classLoader != null) {
            buffer.append(" classLoader=").append(this.classLoader);
        }
        if (this.beanFactories != null) {
            buffer.append(" beanFactories=").append(this.beanFactories);
        }
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.installedContexts = new CopyOnWriteArrayList<KernelControllerContext>();
    }
}

