/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.server.endpoint.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.jms.wireformat.SessionCreateQueueResponse;

public class SessionCreateQueueRequest
extends RequestSupport {
    private String queueName;

    public SessionCreateQueueRequest() {
    }

    public SessionCreateQueueRequest(int objectId, byte version, String queueName) {
        super(objectId, 303, version);
        this.queueName = queueName;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.queueName = is.readUTF();
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return new SessionCreateQueueResponse(endpoint.createQueue(this.queueName));
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeUTF(this.queueName);
        os.flush();
    }
}

