/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.jms.wireformat.CallbackSupport;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.jms.wireformat.PacketSupport;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.callback.Callback;

public class PolledCallbacksDelivery
extends PacketSupport {
    private static final Logger log = Logger.getLogger(PolledCallbacksDelivery.class);
    private List callbacks;
    private String sessionID;

    public PolledCallbacksDelivery() {
    }

    public PolledCallbacksDelivery(List callbacks, String sessionID) {
        super(4);
        this.callbacks = callbacks;
        this.sessionID = sessionID;
    }

    /*
     * WARNING - void declaration
     */
    public void read(DataInputStream is) throws Exception {
        this.sessionID = is.readUTF();
        int len = is.readInt();
        this.callbacks = new ArrayList(len);
        for (int i = 0; i < len; ++i) {
            void var4_4;
            int id = is.readInt();
            switch (id) {
                case 2: {
                    CallbackSupport cs = new ClientDelivery();
                    break;
                }
                case 3: {
                    CallbackSupport cs = new ConnectionFactoryUpdate();
                    break;
                }
                default: {
                    throw new IllegalStateException("Can't deal with methodId=" + id);
                }
            }
            var4_4.read(is);
            Callback cb = new Callback(var4_4);
            this.callbacks.add(cb);
        }
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeUTF(this.sessionID);
        os.writeInt(this.callbacks.size());
        Iterator iter = this.callbacks.iterator();
        while (iter.hasNext()) {
            Callback cb = (Callback)iter.next();
            CallbackSupport cs = (CallbackSupport)cb.getParameter();
            cs.write(os);
        }
        os.flush();
    }

    public Object getPayload() {
        return new InvocationResponse(this.sessionID, this.callbacks, false, null);
    }
}

