/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Map;
import org.jboss.jms.server.endpoint.advised.AdvisedSupport;
import org.jboss.logging.Logger;

public class Dispatcher {
    private static final Logger log = Logger.getLogger(Dispatcher.class);
    public static Dispatcher instance = new Dispatcher();
    private Map targets = new ConcurrentReaderHashMap();

    private Dispatcher() {
    }

    public Object getTarget(int id) {
        return this.getTarget(new Integer(id));
    }

    public Object getTarget(Integer id) {
        return this.targets.get(id);
    }

    public void registerTarget(Integer id, AdvisedSupport obj) {
        this.targets.put(id, obj);
    }

    public void registerTarget(int id, AdvisedSupport obj) {
        this.registerTarget(new Integer(id), obj);
    }

    public boolean unregisterTarget(Integer id, Object endpoint) {
        AdvisedSupport advised = (AdvisedSupport)this.targets.get(id);
        if (advised == null) {
            log.warn("Cannot find object with id " + id + " to register");
            return false;
        }
        if (advised.getEndpoint() != endpoint) {
            log.warn("The object you are trying to deregister is not the same as the one you registered!");
            return false;
        }
        return this.targets.remove(id) != null;
    }

    public boolean unregisterTarget(int id, Object obj) {
        return this.unregisterTarget(new Integer(id), obj);
    }
}

