/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.server.endpoint.ConnectionEndpoint;
import org.jboss.jms.wireformat.ConnectionGetIDBlockResponse;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class ConnectionGetIDBlockRequest
extends RequestSupport {
    private int size;

    public ConnectionGetIDBlockRequest() {
    }

    public ConnectionGetIDBlockRequest(int objectId, byte version, int size) {
        super(objectId, 101, version);
        this.size = size;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.size = is.readInt();
    }

    public ResponseSupport serverInvoke() throws Exception {
        ConnectionEndpoint endpoint = (ConnectionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return new ConnectionGetIDBlockResponse(endpoint.getIdBlock(this.size));
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeInt(this.size);
        os.flush();
    }
}

