/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.wireformat.CallbackSupport;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.MessageFactory;

public class ClientDelivery
extends CallbackSupport {
    private Message msg;
    private int consumerId;
    private long deliveryId;
    private int deliveryCount;

    public ClientDelivery() {
    }

    public ClientDelivery(Message msg, int consumerId, long deliveryId, int deliveryCount) {
        super(2);
        this.msg = msg;
        this.consumerId = consumerId;
        this.deliveryId = deliveryId;
        this.deliveryCount = deliveryCount;
    }

    public void write(DataOutputStream out) throws Exception {
        super.write(out);
        out.writeInt(this.consumerId);
        out.writeInt(this.deliveryCount);
        out.writeLong(this.deliveryId);
        out.writeByte(this.msg.getType());
        this.msg.write(out);
        out.flush();
    }

    public void read(DataInputStream in) throws Exception {
        this.consumerId = in.readInt();
        this.deliveryCount = in.readInt();
        this.deliveryId = in.readLong();
        byte type = in.readByte();
        this.msg = MessageFactory.createMessage(type);
        this.msg.read(in);
    }

    public Message getMessage() {
        return this.msg;
    }

    public int getConsumerId() {
        return this.consumerId;
    }

    public long getDeliveryId() {
        return this.deliveryId;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public String toString() {
        return "ClientDelivery[" + this.msg + "]";
    }
}

