/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSSecurityException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.jms.server.SecurityManager;
import org.jboss.jms.server.security.SecurityActions;
import org.jboss.jms.server.security.SecurityMetadata;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.w3c.dom.Element;

public class SecurityMetadataStore
implements SecurityManager {
    private static final Logger log = Logger.getLogger(SecurityMetadataStore.class);
    private boolean trace = log.isTraceEnabled();
    private Map queueSecurityConf = new HashMap();
    private Map topicSecurityConf = new HashMap();
    private AuthenticationManager authenticationManager;
    private RealmMapping realmMapping;
    private Element defaultSecurityConfig;
    private String securityDomain;

    public SecurityMetadata getSecurityMetadata(boolean isQueue, String destName) {
        SecurityMetadata m = (SecurityMetadata)(isQueue ? this.queueSecurityConf.get(destName) : this.topicSecurityConf.get(destName));
        if (m == null) {
            if (this.defaultSecurityConfig != null) {
                log.debug("No SecurityMetadadata was available for " + destName + ", using default security config");
                try {
                    m = new SecurityMetadata(this.defaultSecurityConfig);
                }
                catch (Exception e) {
                    log.warn("Unable to apply default security for destName, using guest " + destName, e);
                    m = new SecurityMetadata();
                }
            } else {
                log.warn("No SecurityMetadadata was available for " + destName + ", adding guest");
                m = new SecurityMetadata();
            }
        }
        return m;
    }

    public void setSecurityConfig(boolean isQueue, String destName, Element conf) throws Exception {
        if (this.trace) {
            log.trace("adding security configuration for " + (isQueue ? "queue " : "topic ") + destName);
        }
        SecurityMetadata m = new SecurityMetadata(conf);
        if (isQueue) {
            this.queueSecurityConf.put(destName, m);
        } else {
            this.topicSecurityConf.put(destName, m);
        }
    }

    public void clearSecurityConfig(boolean isQueue, String name) throws Exception {
        if (this.trace) {
            log.trace("clearing security configuration for " + (isQueue ? "queue " : "topic ") + name);
        }
        if (isQueue) {
            this.queueSecurityConf.remove(name);
        } else {
            this.topicSecurityConf.remove(name);
        }
    }

    public Subject authenticate(String user, String password) throws JMSSecurityException {
        Subject subject;
        if (this.trace) {
            log.trace("authenticating user " + user);
        }
        SimplePrincipal principal = new SimplePrincipal(user);
        char[] passwordChars = null;
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        if (this.authenticationManager.isValid(principal, passwordChars, subject = new Subject())) {
            SecurityActions.pushSubjectContext(principal, passwordChars, subject);
            return subject;
        }
        throw new JMSSecurityException("User " + user + " is NOT authenticated");
    }

    public boolean authorize(String user, Set rolePrincipals) {
        if (this.trace) {
            log.trace("authorizing user " + user + " for role(s) " + rolePrincipals.toString());
        }
        SimplePrincipal principal = user == null ? null : new SimplePrincipal(user);
        boolean hasRole = this.realmMapping.doesUserHaveRole(principal, rolePrincipals);
        if (this.trace) {
            log.trace("user " + user + (hasRole ? " is " : " is NOT ") + "authorized");
        }
        return hasRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws NamingException {
        block7: {
            if (this.trace) {
                log.trace("initializing SecurityMetadataStore");
            }
            InitialContext ic = new InitialContext();
            try {
                Object mgr = ic.lookup(this.securityDomain);
                log.debug("JaasSecurityManager is " + mgr);
                this.authenticationManager = (AuthenticationManager)mgr;
                this.realmMapping = (RealmMapping)mgr;
                log.trace("SecurityMetadataStore initialized");
            }
            catch (NamingException e) {
                log.warn("Failed to lookup securityDomain " + this.securityDomain, e);
                if (!this.securityDomain.startsWith("java:/jaas/")) {
                    this.authenticationManager = (SubjectSecurityManager)ic.lookup("java:/jaas/" + this.securityDomain);
                    break block7;
                }
                throw e;
            }
            finally {
                ic.close();
            }
        }
    }

    public void stop() throws Exception {
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public Element getDefaultSecurityConfig() {
        return this.defaultSecurityConfig;
    }

    public void setDefaultSecurityConfig(Element conf) throws Exception {
        new SecurityMetadata(conf);
        this.defaultSecurityConfig = conf;
    }
}

