/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.plugin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.jms.server.plugin.contract.JMSUserManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.plugin.JDBCSupport;

public class JDBCJMSUserManager
extends JDBCSupport
implements JMSUserManager {
    private static final Logger log = Logger.getLogger(JDBCJMSUserManager.class);

    public JDBCJMSUserManager(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup) {
        super(ds, tm, sqlProperties, createTablesOnStartup);
    }

    protected Map getDefaultDMLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("SELECT_PRECONF_CLIENTID", "SELECT CLIENTID FROM JBM_USER WHERE USER_ID=?");
        return map;
    }

    protected Map getDefaultDDLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("CREATE_USER_TABLE", "CREATE TABLE JBM_USER (USER_ID VARCHAR(32) NOT NULL, PASSWD VARCHAR(32) NOT NULL, CLIENTID VARCHAR(128), PRIMARY KEY(USER_ID))");
        map.put("CREATE_ROLE_TABLE", "CREATE TABLE JBM_ROLE (ROLE_ID VARCHAR(32) NOT NULL, USER_ID VARCHAR(32) NOT NULL, PRIMARY KEY(USER_ID, ROLE_ID))");
        return map;
    }

    protected boolean ignoreVerificationOnStartup(String statementName) {
        return statementName.startsWith("POPULATE.TABLES.");
    }

    public void start() throws Exception {
        super.start();
        this.insertUserRoleData();
    }

    public void stop() throws Exception {
        super.stop();
    }

    public String getPreConfiguredClientID(String username) throws Exception {
        String string;
        JDBCSupport.TransactionWrapper wrap;
        PreparedStatement ps;
        Connection conn;
        block10: {
            conn = null;
            ps = null;
            ResultSet rs = null;
            wrap = new JDBCSupport.TransactionWrapper(this);
            try {
                conn = this.ds.getConnection();
                ps = conn.prepareStatement(this.getSQLStatement("SELECT_PRECONF_CLIENTID"));
                ps.setString(1, username);
                rs = ps.executeQuery();
                String clientID = null;
                if (rs.next()) {
                    clientID = rs.getString(1);
                }
                string = clientID;
                Object var9_9 = null;
                if (rs == null) break block10;
            }
            catch (SQLException e) {
                try {
                    wrap.exceptionOccurred();
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    wrap.end();
                    throw throwable;
                }
            }
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (conn != null) {
            conn.close();
        }
        wrap.end();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUserRoleData() throws Exception {
        ArrayList<Object> populateTables = new ArrayList<Object>();
        Iterator<Map.Entry<Object, Object>> i = this.sqlProperties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("POPULATE.TABLES.")) continue;
            populateTables.add(entry.getValue());
        }
        if (!populateTables.isEmpty()) {
            JDBCSupport.TransactionWrapper tx;
            block12: {
                Connection conn = null;
                tx = new JDBCSupport.TransactionWrapper(this);
                try {
                    conn = this.ds.getConnection();
                    Iterator iter = populateTables.iterator();
                    while (iter.hasNext()) {
                        String statement = (String)iter.next();
                        try {
                            if (log.isTraceEnabled()) {
                                log.trace("Executing: " + statement);
                            }
                            conn.createStatement().executeUpdate(statement);
                        }
                        catch (SQLException e) {
                            log.debug("Failed to execute " + statement, e);
                        }
                    }
                    Object var8_7 = null;
                    if (conn == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    tx.end();
                    throw throwable;
                }
                try {
                    conn.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            tx.end();
            {
            }
        }
    }
}

