/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.jboss.aop.AspectManager;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.SecurityManager;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.endpoint.ConnectionEndpoint;
import org.jboss.jms.server.endpoint.ServerConnectionFactoryEndpoint;
import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
import org.jboss.jms.server.endpoint.advised.AdvisedSupport;
import org.jboss.jms.server.endpoint.advised.SessionAdvised;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.server.remoting.JMSWireFormat;
import org.jboss.jms.tx.ClientTransaction;
import org.jboss.jms.tx.TransactionRequest;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.jms.util.ToString;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.IDBlock;
import org.jboss.messaging.core.plugin.contract.MessageStore;
import org.jboss.messaging.core.plugin.contract.PostOffice;
import org.jboss.messaging.core.tx.MessagingXid;
import org.jboss.messaging.core.tx.Transaction;
import org.jboss.messaging.core.tx.TransactionRepository;
import org.jboss.remoting.Client;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class ServerConnectionEndpoint
implements ConnectionEndpoint {
    private static final Logger log = Logger.getLogger(ServerConnectionEndpoint.class);
    private static boolean trace = log.isTraceEnabled();
    private int id;
    private volatile boolean closed;
    private volatile boolean started;
    private String clientID;
    private String username;
    private String password;
    private String remotingClientSessionID;
    private String jmsClientVMID;
    private ServerPeer serverPeer;
    private PostOffice postOffice;
    private SecurityManager sm;
    private ConnectionManager cm;
    private TransactionRepository tr;
    private MessageStore ms;
    private ServerInvokerCallbackHandler callbackHandler;
    private Map sessions;
    private Set temporaryDestinations;
    private int prefetchSize;
    private int defaultTempQueueFullSize;
    private int defaultTempQueuePageSize;
    private int defaultTempQueueDownCacheSize;
    private int dupsOKBatchSize;
    private ServerConnectionFactoryEndpoint cfendpoint;
    private byte usingVersion;
    private Integer failedNodeID;

    public ServerConnectionEndpoint(ServerPeer serverPeer, String clientID, String username, String password, int prefetchSize, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int failedNodeID, ServerConnectionFactoryEndpoint cfendpoint, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler, int dupsOKBatchSize) throws Exception {
        this.serverPeer = serverPeer;
        this.cfendpoint = cfendpoint;
        this.sm = serverPeer.getSecurityManager();
        this.tr = serverPeer.getTxRepository();
        this.cm = serverPeer.getConnectionManager();
        this.ms = serverPeer.getMessageStore();
        this.postOffice = serverPeer.getPostOfficeInstance();
        this.started = false;
        this.id = serverPeer.getNextObjectID();
        this.clientID = clientID;
        this.prefetchSize = prefetchSize;
        this.defaultTempQueueFullSize = defaultTempQueueFullSize;
        this.defaultTempQueuePageSize = defaultTempQueuePageSize;
        this.defaultTempQueueDownCacheSize = defaultTempQueueDownCacheSize;
        this.dupsOKBatchSize = dupsOKBatchSize;
        this.sessions = new HashMap();
        this.temporaryDestinations = new HashSet();
        this.username = username;
        this.password = password;
        if (failedNodeID > 0) {
            this.failedNodeID = new Integer(failedNodeID);
        }
        this.remotingClientSessionID = remotingSessionID;
        this.jmsClientVMID = clientVMID;
        this.usingVersion = versionToUse;
        this.serverPeer.getConnectionManager().registerConnection(this.jmsClientVMID, this.remotingClientSessionID, this);
        this.callbackHandler = callbackHandler;
        Client callbackClient = callbackHandler.getCallbackClient();
        if (callbackClient != null) {
            callbackClient.setSubsystem("CALLBACK");
            callbackClient.setMarshaller(new JMSWireFormat());
            callbackClient.setUnMarshaller(new JMSWireFormat());
        } else {
            log.debug("ServerInvokerCallbackHandler callback Client is not available: must be using pull callbacks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionDelegate createSessionDelegate(boolean transacted, int acknowledgmentMode, boolean isXA) throws JMSException {
        try {
            SessionAdvised advised;
            log.debug(this + " creating " + (transacted ? "transacted" : "non transacted") + " session, " + ToString.acknowledgmentMode(acknowledgmentMode) + ", " + (isXA ? "XA" : "non XA"));
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            int sessionID = this.serverPeer.getNextObjectID();
            ServerSessionEndpoint ep = new ServerSessionEndpoint(sessionID, this);
            Map map = this.sessions;
            synchronized (map) {
                this.sessions.put(new Integer(sessionID), ep);
            }
            AspectManager aspectManager = AspectManager.instance();
            synchronized (aspectManager) {
                advised = new SessionAdvised(ep);
            }
            SessionAdvised sessionAdvised = advised;
            Integer iSessionID = new Integer(sessionID);
            this.serverPeer.addSession(iSessionID, ep);
            Dispatcher.instance.registerTarget(iSessionID, (AdvisedSupport)sessionAdvised);
            log.debug("created and registered " + ep);
            ClientSessionDelegate d = new ClientSessionDelegate(sessionID, this.dupsOKBatchSize);
            log.debug("created " + d);
            return d;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " createSessionDelegate");
        }
    }

    public String getClientID() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            return this.clientID;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " getClientID");
        }
    }

    public void setClientID(String clientID) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            if (this.clientID != null) {
                throw new IllegalStateException("Cannot set clientID, already set as " + this.clientID);
            }
            this.serverPeer.checkClientID(clientID);
            log.debug(this + "setting client ID to " + clientID);
            this.clientID = clientID;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " setClientID");
        }
    }

    public void start() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            this.setStarted(true);
            log.debug(this + " started");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " start");
        }
    }

    public synchronized void stop() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            this.setStarted(false);
            log.debug("Connection " + this.id + " stopped");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            HashMap sessionsClone;
            if (trace) {
                log.trace(this + " close()");
            }
            if (this.closed) {
                log.warn("Connection is already closed");
                return;
            }
            Object object = this.sessions;
            synchronized (object) {
                sessionsClone = new HashMap(this.sessions);
            }
            Iterator i = sessionsClone.values().iterator();
            while (i.hasNext()) {
                ServerSessionEndpoint sess = (ServerSessionEndpoint)i.next();
                sess.localClose();
            }
            this.sessions.clear();
            object = this.temporaryDestinations;
            synchronized (object) {
                Iterator i2 = this.temporaryDestinations.iterator();
                while (i2.hasNext()) {
                    JBossDestination dest = (JBossDestination)i2.next();
                    if (!dest.isQueue()) continue;
                    this.postOffice.unbindQueue(dest.getName());
                    String counterName = "TempQueue." + dest.getName();
                    MessageCounter counter = this.serverPeer.getMessageCounterManager().unregisterMessageCounter(counterName);
                    if (counter != null) continue;
                    throw new IllegalStateException("Cannot find counter to unregister " + counterName);
                }
                this.temporaryDestinations.clear();
            }
            this.cm.unregisterConnection(this.jmsClientVMID, this.remotingClientSessionID);
            Dispatcher.instance.unregisterTarget(this.id, (Object)this);
            this.closed = true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " close");
        }
    }

    public long closing() throws JMSException {
        log.trace(this + " closing (noop)");
        return -1L;
    }

    public void sendTransaction(TransactionRequest request, boolean checkForDuplicates) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            if (request.getRequestType() == 0) {
                if (trace) {
                    log.trace(this + " received ONE_PHASE_COMMIT request");
                }
                Transaction tx = this.tr.createTransaction();
                this.processTransaction(request.getState(), tx, checkForDuplicates);
                tx.commit();
            } else if (request.getRequestType() == 2) {
                if (trace) {
                    log.trace(this + " received TWO_PHASE_COMMIT prepare request");
                }
                Transaction tx = this.tr.createTransaction(request.getXid());
                this.processTransaction(request.getState(), tx, checkForDuplicates);
                tx.prepare();
            } else if (request.getRequestType() == 3) {
                if (trace) {
                    log.trace(this + " received TWO_PHASE_COMMIT commit request");
                }
                Transaction tx = this.tr.getPreparedTx(request.getXid());
                if (trace) {
                    log.trace("Committing " + tx);
                }
                tx.commit();
            } else if (request.getRequestType() == 4) {
                if (trace) {
                    log.trace(this + " received TWO_PHASE_COMMIT rollback request");
                }
                Transaction tx = this.tr.getPreparedTx(request.getXid());
                if (trace) {
                    log.trace(this + " rolling back " + tx);
                }
                tx.rollback();
            }
            if (trace) {
                log.trace(this + " processed transaction successfully");
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " sendTransaction");
        }
    }

    public MessagingXid[] getPreparedTransactions() throws JMSException {
        try {
            List xids = this.tr.recoverPreparedTransactions();
            return xids.toArray(new MessagingXid[xids.size()]);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " getPreparedTransactions");
        }
    }

    public IDBlock getIdBlock(int size) throws JMSException {
        try {
            return this.serverPeer.getMessageIDManager().getIDBlock(size);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " getIdBlock");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SecurityManager getSecurityManager() {
        return this.sm;
    }

    public ServerInvokerCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public ServerPeer getServerPeer() {
        return this.serverPeer;
    }

    public ServerConnectionFactoryEndpoint getConnectionFactoryEndpoint() {
        return this.cfendpoint;
    }

    public String toString() {
        return "ConnectionEndpoint[" + this.id + "]";
    }

    byte getUsingVersion() {
        return this.usingVersion;
    }

    int getPrefetchSize() {
        return this.prefetchSize;
    }

    int getDefaultTempQueueFullSize() {
        return this.defaultTempQueueFullSize;
    }

    int getDefaultTempQueuePageSize() {
        return this.defaultTempQueuePageSize;
    }

    int getDefaultTempQueueDownCacheSize() {
        return this.defaultTempQueueDownCacheSize;
    }

    int getConnectionID() {
        return this.id;
    }

    boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(int sessionId) throws Exception {
        Map map = this.sessions;
        synchronized (map) {
            if (this.sessions.remove(new Integer(sessionId)) == null) {
                throw new IllegalStateException("Cannot find session with id " + sessionId + " to remove");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTemporaryDestination(Destination dest) {
        Set set = this.temporaryDestinations;
        synchronized (set) {
            this.temporaryDestinations.add(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTemporaryDestination(Destination dest) {
        Set set = this.temporaryDestinations;
        synchronized (set) {
            this.temporaryDestinations.remove(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasTemporaryDestination(Destination dest) {
        Set set = this.temporaryDestinations;
        synchronized (set) {
            return this.temporaryDestinations.contains(dest);
        }
    }

    String getRemotingClientSessionID() {
        return this.remotingClientSessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(JBossMessage msg, Transaction tx, boolean checkForDuplicates) throws Exception {
        if (trace) {
            log.trace(this + " sending " + msg + (tx == null ? " non-transactionally" : " in " + tx));
        }
        JBossDestination dest = (JBossDestination)msg.getJMSDestination();
        msg.setConnectionID(this.id);
        if (checkForDuplicates && this.serverPeer.getPersistenceManagerInstance().referenceExists(msg.getMessageID())) {
            return;
        }
        if (this.failedNodeID != null) {
            msg.putHeader("FAILED_NODE_ID", this.failedNodeID);
        }
        MessageReference ref = null;
        try {
            ref = this.ms.reference(msg);
            long schedDeliveryTime = msg.getScheduledDeliveryTime();
            if (schedDeliveryTime > 0L) {
                ref.setScheduledDeliveryTime(schedDeliveryTime);
            }
            if (dest.isQueue()) {
                if (!this.postOffice.route(ref, new JMSCondition(true, dest.getName()), tx)) {
                    throw new JMSException("Failed to route " + ref + " to " + dest.getName());
                }
            } else {
                this.postOffice.route(ref, new JMSCondition(false, dest.getName()), tx);
            }
        }
        finally {
            if (ref != null) {
                ref.releaseMemoryReference();
            }
        }
        if (trace) {
            log.trace("sent " + msg);
        }
    }

    Integer getFailedNodeID() {
        return this.failedNodeID;
    }

    boolean isFailoverConnection() {
        return this.failedNodeID != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarted(boolean s) throws Throwable {
        HashMap sessionsClone = null;
        Map map = this.sessions;
        synchronized (map) {
            sessionsClone = new HashMap(this.sessions);
        }
        Iterator i = sessionsClone.values().iterator();
        while (i.hasNext()) {
            ServerSessionEndpoint sd = (ServerSessionEndpoint)i.next();
            sd.setStarted(s);
        }
        this.started = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransaction(ClientTransaction txState, Transaction tx, boolean checkForDuplicates) throws Throwable {
        if (trace) {
            log.trace(this + " processing transaction " + tx);
        }
        boolean firstIteration = true;
        Map map = this.sessions;
        synchronized (map) {
            Iterator i = txState.getSessionStates().iterator();
            while (i.hasNext()) {
                ClientTransaction.SessionTxState sessionState = (ClientTransaction.SessionTxState)i.next();
                Iterator j = sessionState.getMsgs().iterator();
                while (j.hasNext()) {
                    JBossMessage message = (JBossMessage)j.next();
                    if (checkForDuplicates && firstIteration) {
                        firstIteration = false;
                        if (this.serverPeer.getPersistenceManagerInstance().referenceExists(message.getMessageID())) {
                            log.debug("Transaction " + tx + " was previously completed, ignoring call");
                            return;
                        }
                    }
                    this.sendMessage(message, tx, false);
                }
                ServerSessionEndpoint session = this.serverPeer.getSession(new Integer(sessionState.getSessionId()));
                if (session == null) {
                    throw new IllegalStateException("Cannot find session with id " + sessionState.getSessionId());
                }
                session.acknowledgeTransactionally(sessionState.getAcks(), tx);
            }
        }
        if (trace) {
            log.trace(this + " processed transaction " + tx);
        }
    }
}

