/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.container;

import java.util.HashSet;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.server.SecurityManager;
import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
import org.jboss.jms.server.endpoint.ServerConsumerEndpoint;
import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
import org.jboss.jms.server.endpoint.advised.ConsumerAdvised;
import org.jboss.jms.server.endpoint.advised.SessionAdvised;
import org.jboss.jms.server.security.SecurityMetadata;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;

public class SecurityAspect {
    private static final Logger log = Logger.getLogger(SecurityAspect.class);
    private boolean trace = log.isTraceEnabled();
    private Set readCache = new HashSet();
    private Set writeCache = new HashSet();
    private Set createCache = new HashSet();
    private static final long INVALIDATION_INTERVAL = 15000L;
    private long lastCheck;

    public Object handleCreateConsumerDelegate(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        Destination dest = (Destination)mi.getArguments()[0];
        SessionAdvised del = (SessionAdvised)invocation.getTargetObject();
        ServerSessionEndpoint sess = (ServerSessionEndpoint)del.getEndpoint();
        this.check(dest, CheckType.READ, sess.getConnectionEndpoint());
        String subscriptionName = (String)mi.getArguments()[3];
        if (subscriptionName != null) {
            this.check(dest, CheckType.CREATE, sess.getConnectionEndpoint());
        }
        return invocation.invokeNext();
    }

    public Object handleCreateBrowserDelegate(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        Destination dest = (Destination)mi.getArguments()[0];
        SessionAdvised del = (SessionAdvised)invocation.getTargetObject();
        ServerSessionEndpoint sess = (ServerSessionEndpoint)del.getEndpoint();
        this.check(dest, CheckType.READ, sess.getConnectionEndpoint());
        return invocation.invokeNext();
    }

    public Object handleSend(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        Message m = (Message)mi.getArguments()[0];
        Destination dest = m.getJMSDestination();
        SessionAdvised del = (SessionAdvised)invocation.getTargetObject();
        ServerSessionEndpoint se = (ServerSessionEndpoint)del.getEndpoint();
        ServerConnectionEndpoint ce = se.getConnectionEndpoint();
        this.check(dest, CheckType.WRITE, ce);
        return invocation.invokeNext();
    }

    protected void checkConsumerAccess(Invocation invocation) throws Throwable {
        ConsumerAdvised del = (ConsumerAdvised)invocation.getTargetObject();
        ServerConsumerEndpoint cons = (ServerConsumerEndpoint)del.getEndpoint();
        ServerConnectionEndpoint conn = cons.getSessionEndpoint().getConnectionEndpoint();
        JBossDestination dest = cons.getDestination();
        this.check(dest, CheckType.READ, conn);
    }

    private boolean checkCached(Destination dest, CheckType checkType) {
        long now = System.currentTimeMillis();
        boolean granted = false;
        if (now - this.lastCheck > 15000L) {
            this.readCache.clear();
            this.writeCache.clear();
            this.createCache.clear();
        } else {
            switch (checkType.type) {
                case 0: {
                    granted = this.readCache.contains(dest);
                    break;
                }
                case 1: {
                    granted = this.writeCache.contains(dest);
                    break;
                }
                case 2: {
                    granted = this.createCache.contains(dest);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid checkType:" + checkType);
                }
            }
        }
        this.lastCheck = now;
        return granted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(Destination dest, CheckType checkType, ServerConnectionEndpoint conn) throws JMSSecurityException {
        if (this.trace) {
            log.trace("checking access permissions to " + dest);
        }
        if (this.checkCached(dest, checkType)) {
            return;
        }
        JBossDestination jbd = (JBossDestination)dest;
        boolean isQueue = jbd.isQueue();
        String name = jbd.getName();
        SecurityManager sm = conn.getSecurityManager();
        SecurityMetadata securityMetadata = sm.getSecurityMetadata(isQueue, name);
        if (securityMetadata == null) {
            throw new JMSSecurityException("No security configuration avaliable for " + name);
        }
        sm.authenticate(conn.getUsername(), conn.getPassword());
        Set principals = checkType == CheckType.READ ? securityMetadata.getReadPrincipals() : (checkType == CheckType.WRITE ? securityMetadata.getWritePrincipals() : securityMetadata.getCreatePrincipals());
        try {
            if (!sm.authorize(conn.getUsername(), principals)) {
                String msg = "User: " + conn.getUsername() + " is not authorized to " + (checkType == CheckType.READ ? "read from" : (checkType == CheckType.WRITE ? "write to" : "create durable sub on")) + " destination " + name;
                throw new JMSSecurityException(msg);
            }
        }
        finally {
            SecurityAssociation.popSubjectContext();
        }
        switch (checkType.type) {
            case 0: {
                this.readCache.add(dest);
                break;
            }
            case 1: {
                this.writeCache.add(dest);
                break;
            }
            case 2: {
                this.createCache.add(dest);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid checkType:" + checkType);
            }
        }
    }

    private static class CheckType {
        private int type;
        public static final int TYPE_READ = 0;
        public static final int TYPE_WRITE = 1;
        public static final int TYPE_CREATE = 2;
        public static CheckType READ = new CheckType(0);
        public static CheckType WRITE = new CheckType(1);
        public static CheckType CREATE = new CheckType(2);

        private CheckType(int type) {
            this.type = type;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CheckType)) {
                return false;
            }
            CheckType ct = (CheckType)other;
            return ct.type == this.type;
        }

        public int hashCode() {
            return this.type;
        }
    }
}

