/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.connectionfactory;

import javax.management.ObjectName;
import org.jboss.jms.client.plugin.LoadBalancingFactory;
import org.jboss.jms.server.ConnectionFactoryManager;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.jms.server.ConnectorManager;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.connectionfactory.JNDIBindings;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.remoting.InvokerLocator;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class ConnectionFactory
extends ServiceMBeanSupport {
    protected String clientID;
    protected JNDIBindings jndiBindings;
    protected int prefetchSize = 150;
    protected boolean clustered;
    protected LoadBalancingFactory loadBalancingFactory;
    protected int defaultTempQueueFullSize = 200000;
    protected int defaultTempQueuePageSize = 2000;
    protected int defaultTempQueueDownCacheSize = 2000;
    protected int dupsOKBatchSize = 1000;
    protected ObjectName serverPeerObjectName;
    protected ConnectionFactoryManager connectionFactoryManager;
    protected ConnectorManager connectorManager;
    protected ConnectionManager connectionManager;
    protected ObjectName connectorObjectName;
    protected boolean started;

    public ConnectionFactory() {
        this((String)null);
    }

    public ConnectionFactory(String clientID) {
        this.clientID = clientID;
        this.loadBalancingFactory = LoadBalancingFactory.getDefaultFactory();
    }

    public synchronized void startService() throws Exception {
        try {
            boolean enablePing;
            this.log.debug(this + " starting");
            this.started = true;
            if (this.connectorObjectName == null) {
                throw new IllegalArgumentException("A Connector must be specified for each Connection Factory");
            }
            if (this.serverPeerObjectName == null) {
                throw new IllegalArgumentException("ServerPeer must be specified for each Connection Factory");
            }
            String locatorURI = (String)this.server.getAttribute(this.connectorObjectName, "InvokerLocator");
            ServerPeer serverPeer = (ServerPeer)this.server.getAttribute(this.serverPeerObjectName, "Instance");
            this.connectionFactoryManager = serverPeer.getConnectionFactoryManager();
            this.connectorManager = serverPeer.getConnectorManager();
            this.connectionManager = serverPeer.getConnectionManager();
            int refCount = this.connectorManager.registerConnector(this.connectorObjectName.getCanonicalName());
            long leasePeriod = (Long)this.server.getAttribute(this.connectorObjectName, "LeasePeriod");
            boolean bl = enablePing = leasePeriod > 0L;
            if (refCount == 1 && enablePing) {
                this.server.invoke(this.connectorObjectName, "addConnectionListener", new Object[]{this.connectionManager}, new String[]{"org.jboss.remoting.ConnectionListener"});
            }
            this.connectionFactoryManager.registerConnectionFactory(this.getServiceName().getCanonicalName(), this.clientID, this.jndiBindings, locatorURI, enablePing, this.prefetchSize, this.defaultTempQueueFullSize, this.defaultTempQueuePageSize, this.defaultTempQueueDownCacheSize, this.dupsOKBatchSize, this.clustered, this.loadBalancingFactory);
            InvokerLocator locator = new InvokerLocator(locatorURI);
            String info = "Connector " + locator.getProtocol() + "://" + locator.getHost() + ":" + locator.getPort();
            info = enablePing ? info + " has leasing enabled, lease period " + leasePeriod + " milliseconds" : info + " has lease disabled";
            this.log.info(info);
            this.log.info(this + " started");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    public synchronized void stopService() throws Exception {
        try {
            this.started = false;
            this.connectionFactoryManager.unregisterConnectionFactory(this.getServiceName().getCanonicalName(), this.clustered);
            this.connectorManager.unregisterConnector(this.connectorObjectName.getCanonicalName());
            this.log.info(this + " undeployed");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    public int getDefaultTempQueueFullSize() {
        return this.defaultTempQueueFullSize;
    }

    public void setDefaultTempQueueFullSize(int size) {
        this.defaultTempQueueFullSize = size;
    }

    public int getDefaultTempQueuePageSize() {
        return this.defaultTempQueuePageSize;
    }

    public void setDefaultTempQueuePageSize(int size) {
        this.defaultTempQueuePageSize = size;
    }

    public int getDefaultTempQueueDownCacheSize() {
        return this.defaultTempQueueDownCacheSize;
    }

    public void setDefaultTempQueueDownCacheSize(int size) {
        this.defaultTempQueueDownCacheSize = size;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setJNDIBindings(Element e) throws Exception {
        this.jndiBindings = new JNDIBindings(e);
    }

    public Element getJNDIBindings() {
        if (this.jndiBindings == null) {
            return null;
        }
        return this.jndiBindings.getDelegate();
    }

    public void setServerPeer(ObjectName on) {
        if (this.started) {
            this.log.warn("Cannot change the value of associated server ObjectName after initialization!");
            return;
        }
        this.serverPeerObjectName = on;
    }

    public ObjectName getServerPeer() {
        return this.serverPeerObjectName;
    }

    public void setConnector(ObjectName on) {
        if (this.started) {
            this.log.warn("Cannot change the value of associated connector ObjectName after initialization!");
            return;
        }
        this.connectorObjectName = on;
    }

    public ObjectName getConnector() {
        return this.connectorObjectName;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        if (this.started) {
            this.log.warn("Clustered can only be changed when connection factory is stopped");
            return;
        }
        this.clustered = clustered;
    }

    public String getLoadBalancingFactory() {
        return this.loadBalancingFactory.getClass().getName();
    }

    public void setLoadBalancingFactory(String factoryName) throws Exception {
        if (this.started) {
            this.log.warn("Load balancing policy can only be changed when connection factory is stopped");
            return;
        }
        Class<?> clz = Class.forName(factoryName);
        this.loadBalancingFactory = (LoadBalancingFactory)clz.newInstance();
    }

    public void setDupsOKBatchSize(int size) throws Exception {
        if (this.started) {
            this.log.warn("DupsOKBatchSize can only be changed when connection factory is stopped");
            return;
        }
        this.dupsOKBatchSize = size;
    }

    public int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public String toString() {
        return "[" + this.jndiBindings.toString() + "]";
    }
}

