/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.recovery;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public class XAResourceWrapper
implements XAResource,
ExceptionListener {
    private static final Logger log = Logger.getLogger(XAResourceWrapper.class);
    private String providerName;
    private static final Object lock = new Object();
    private XAConnection connection;
    private XAResource delegate;

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public Xid[] recover(int flag) throws XAException {
        log.debug("Recover " + this.providerName);
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.recover(flag);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        log.debug("Commit " + this.providerName + " xid " + " onePhase=" + onePhase);
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        log.debug("Rollback " + this.providerName + " xid ");
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.rollback(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void forget(Xid xid) throws XAException {
        log.debug("Forget " + this.providerName + " xid ");
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.forget(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof XAResourceWrapper) {
            xaRes = ((XAResourceWrapper)xaRes).getDelegate();
        }
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.isSameRM(xaRes);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public int prepare(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.prepare(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.start(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.end(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public int getTransactionTimeout() throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void onException(JMSException exception) {
        log.warn("Notified of connection failure in recovery delegate for provider " + this.providerName, exception);
        this.close();
    }

    public XAResource getDelegate() throws XAException {
        XAResource result = null;
        Exception error = null;
        try {
            result = this.connect();
        }
        catch (Exception e) {
            error = e;
        }
        if (result == null) {
            XAException xae = new XAException("Error trying to connect to provider " + this.providerName);
            xae.errorCode = -3;
            if (error != null) {
                xae.initCause(error);
            }
            log.debug("Cannot get delegate XAResource", xae);
            throw xae;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource connect() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (this.delegate != null) {
                return this.delegate;
            }
        }
        XAConnection xaConnection = this.getConnectionFactory().createXAConnection();
        Object object2 = lock;
        synchronized (object2) {
            this.connection = xaConnection;
        }
        try {
            XASession session = this.connection.createXASession();
            XAResource result = session.getXAResource();
            Object object3 = lock;
            synchronized (object3) {
                this.delegate = result;
            }
            return this.delegate;
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAConnectionFactory getConnectionFactory() throws Exception {
        if (this.providerName == null) {
            throw new IllegalArgumentException("Null provider name");
        }
        String providerAdapterJNDI = this.providerName;
        if (!providerAdapterJNDI.startsWith("java:")) {
            providerAdapterJNDI = "java:" + providerAdapterJNDI;
        }
        Context ctx = new InitialContext();
        JMSProviderAdapter adapter = (JMSProviderAdapter)Util.lookup(providerAdapterJNDI, JMSProviderAdapter.class);
        String connectionFactoryRef = adapter.getFactoryRef();
        if (connectionFactoryRef == null) {
            throw new IllegalStateException("Provider '" + this.providerName + "' has no FactoryRef");
        }
        ctx = adapter.getInitialContext();
        try {
            XAConnectionFactory xAConnectionFactory = (XAConnectionFactory)Util.lookup(ctx, connectionFactoryRef, XAConnectionFactory.class);
            return xAConnectionFactory;
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            XAConnection oldConnection = null;
            Object object = lock;
            synchronized (object) {
                oldConnection = this.connection;
                this.connection = null;
                this.delegate = null;
            }
            if (oldConnection != null) {
                oldConnection.close();
            }
        }
        catch (Exception ignored) {
            log.trace("Ignored error during close", ignored);
        }
    }

    protected XAException check(XAException e) throws XAException {
        if (e.errorCode == -3 || e.errorCode == -7) {
            log.debug("Fatal error in provider " + this.providerName, e);
            this.close();
        }
        throw e;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

