/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.state;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jms.MessageListener;
import org.jboss.jms.client.delegate.ClientBrowserDelegate;
import org.jboss.jms.client.delegate.ClientConsumerDelegate;
import org.jboss.jms.client.delegate.ClientProducerDelegate;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.MessageCallbackHandler;
import org.jboss.jms.client.state.BrowserState;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.client.state.ConsumerState;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.client.state.HierarchicalStateSupport;
import org.jboss.jms.client.state.ProducerState;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.server.Version;
import org.jboss.jms.server.endpoint.DeliveryInfo;
import org.jboss.jms.server.endpoint.DeliveryRecovery;
import org.jboss.jms.tx.MessagingXAResource;
import org.jboss.jms.tx.ResourceManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.ClearableQueuedExecutor;

public class SessionState
extends HierarchicalStateSupport {
    protected static Logger log = Logger.getLogger(SessionState.class);
    private ConnectionState parent;
    private SessionDelegate delegate;
    private int sessionID;
    private int acknowledgeMode;
    private boolean transacted;
    private boolean xa;
    private MessagingXAResource xaResource;
    private Object currentTxId;
    private ClearableQueuedExecutor executor;
    private boolean recoverCalled;
    private List clientAckList;
    private DeliveryInfo autoAckInfo;
    private Map callbackHandlers;
    private int dupsOKBatchSize;
    private LinkedList asfMessages = new LinkedList();
    private MessageListener sessionListener;

    public SessionState(ConnectionState parent, ClientSessionDelegate delegate, boolean transacted, int ackMode, boolean xa, int dupsOKBatchSize) {
        super(parent, delegate);
        this.sessionID = delegate.getID();
        this.children = new HashSet();
        this.acknowledgeMode = ackMode;
        this.transacted = transacted;
        this.xa = xa;
        this.dupsOKBatchSize = dupsOKBatchSize;
        if (xa) {
            this.xaResource = new MessagingXAResource(parent.getResourceManager(), this);
        }
        if (transacted) {
            this.currentTxId = parent.getResourceManager().createLocalTx();
        }
        this.executor = new ClearableQueuedExecutor((Channel)new LinkedQueue());
        this.clientAckList = new ArrayList();
        this.callbackHandlers = new HashMap();
    }

    public DelegateSupport getDelegate() {
        return (DelegateSupport)((Object)this.delegate);
    }

    public void setDelegate(DelegateSupport delegate) {
        this.delegate = (SessionDelegate)((Object)delegate);
    }

    public HierarchicalState getParent() {
        return this.parent;
    }

    public void setParent(HierarchicalState parent) {
        this.parent = (ConnectionState)parent;
    }

    public Version getVersionToUse() {
        return this.parent.getVersionToUse();
    }

    public int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public MessageListener getDistinguishedListener() {
        return this.sessionListener;
    }

    public void setDistinguishedListener(MessageListener listener) {
        this.sessionListener = listener;
    }

    public LinkedList getASFMessages() {
        return this.asfMessages;
    }

    public void synchronizeWith(HierarchicalState ns) throws Exception {
        SessionState newState = (SessionState)ns;
        int oldSessionID = this.sessionID;
        this.sessionID = newState.sessionID;
        this.executor.clearAllExceptCurrentTask();
        ClientSessionDelegate newDelegate = (ClientSessionDelegate)newState.getDelegate();
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            HierarchicalState child = (HierarchicalState)i.next();
            if (child instanceof ConsumerState) {
                ConsumerState consState = (ConsumerState)child;
                ClientConsumerDelegate consDelegate = (ClientConsumerDelegate)consState.getDelegate();
                ClientConsumerDelegate newConsDelegate = (ClientConsumerDelegate)newDelegate.createConsumerDelegate(consState.getDestination(), consState.getSelector(), consState.isNoLocal(), consState.getSubscriptionName(), consState.isConnectionConsumer());
                log.debug(this + " created new consumer " + newConsDelegate);
                consDelegate.synchronizeWith(newConsDelegate);
                log.debug(this + " synchronized failover consumer " + consDelegate);
                continue;
            }
            if (child instanceof ProducerState) {
                ProducerState prodState = (ProducerState)child;
                ClientProducerDelegate prodDelegate = (ClientProducerDelegate)prodState.getDelegate();
                ClientProducerDelegate newProdDelegate = (ClientProducerDelegate)newDelegate.createProducerDelegate((JBossDestination)prodState.getDestination());
                log.debug(this + " created new producer " + newProdDelegate);
                prodDelegate.synchronizeWith(newProdDelegate);
                log.debug(this + " synchronized failover producer " + prodDelegate);
                continue;
            }
            if (!(child instanceof BrowserState)) continue;
            BrowserState browserState = (BrowserState)child;
            ClientBrowserDelegate browserDelegate = (ClientBrowserDelegate)browserState.getDelegate();
            ClientBrowserDelegate newBrowserDelegate = (ClientBrowserDelegate)newDelegate.createBrowserDelegate(browserState.getJmsDestination(), browserState.getMessageSelector());
            log.debug(this + " created new browser " + newBrowserDelegate);
            browserDelegate.synchronizeWith(newBrowserDelegate);
            log.debug(this + " synchronized failover browser " + browserDelegate);
        }
        ConnectionState connState = (ConnectionState)this.getParent();
        ResourceManager rm = connState.getResourceManager();
        rm.handleFailover(connState.getServerID(), oldSessionID, newState.sessionID);
        ArrayList<DeliveryInfo> ackInfos = Collections.EMPTY_LIST;
        if (!this.isTransacted() || this.isXA() && this.getCurrentTxId() == null) {
            log.debug(this + " is not transacted (or XA with no transaction set), " + "retrieving deliveries from session state");
            if (this.getAcknowledgeMode() == 2) {
                Iterator i2 = this.getClientAckList().iterator();
                while (i2.hasNext()) {
                    DeliveryInfo info = (DeliveryInfo)i2.next();
                    if (info.getMessageProxy().getMessage().isReliable()) continue;
                    i2.remove();
                    log.debug("removed non persistent delivery " + info);
                }
                ackInfos = this.getClientAckList();
            } else {
                DeliveryInfo autoAck = this.getAutoAckInfo();
                if (autoAck != null) {
                    if (!autoAck.getMessageProxy().getMessage().isReliable()) {
                        this.setAutoAckInfo(null);
                    } else {
                        ackInfos = new ArrayList<DeliveryInfo>();
                        ackInfos.add(autoAck);
                    }
                }
            }
            log.debug(this + " retrieved " + ackInfos.size() + " deliveries");
        } else {
            ackInfos = rm.getDeliveriesForSession(this.getSessionID());
        }
        if (!ackInfos.isEmpty()) {
            ArrayList<DeliveryRecovery> recoveryInfos = new ArrayList<DeliveryRecovery>();
            Iterator i3 = ackInfos.iterator();
            while (i3.hasNext()) {
                DeliveryInfo del = (DeliveryInfo)i3.next();
                DeliveryRecovery recInfo = new DeliveryRecovery(del.getMessageProxy().getDeliveryId(), del.getMessageProxy().getMessage().getMessageID(), del.getQueueName());
                recoveryInfos.add(recInfo);
            }
            log.debug(this + " sending delivery recovery " + recoveryInfos + " on failover");
            newDelegate.recoverDeliveries(recoveryInfos);
        } else {
            log.debug(this + " no delivery recovery info to send on failover");
        }
    }

    public List getClientAckList() {
        return this.clientAckList;
    }

    public void setClientAckList(List list2) {
        this.clientAckList = list2;
    }

    public DeliveryInfo getAutoAckInfo() {
        return this.autoAckInfo;
    }

    public void setAutoAckInfo(DeliveryInfo info) {
        if (info != null && this.autoAckInfo != null) {
            throw new IllegalStateException("There is already a delivery set for auto ack");
        }
        this.autoAckInfo = info;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public boolean isXA() {
        return this.xa;
    }

    public MessagingXAResource getXAResource() {
        return this.xaResource;
    }

    public QueuedExecutor getExecutor() {
        return this.executor;
    }

    public Object getCurrentTxId() {
        return this.currentTxId;
    }

    public boolean isRecoverCalled() {
        return this.recoverCalled;
    }

    public void setCurrentTxId(Object id) {
        this.currentTxId = id;
    }

    public void setRecoverCalled(boolean recoverCalled) {
        this.recoverCalled = recoverCalled;
    }

    public MessageCallbackHandler getCallbackHandler(int consumerID) {
        return (MessageCallbackHandler)this.callbackHandlers.get(new Integer(consumerID));
    }

    public void addCallbackHandler(MessageCallbackHandler handler) {
        this.callbackHandlers.put(new Integer(handler.getConsumerId()), handler);
    }

    public void removeCallbackHandler(MessageCallbackHandler handler) {
        this.callbackHandlers.remove(new Integer(handler.getConsumerId()));
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String toString() {
        return "SessionState[" + this.sessionID + "]";
    }
}

