/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;

public class StatefulBeanContextReference
implements Externalizable {
    private static final long serialVersionUID = 2644760020735482423L;
    private transient StatefulBeanContext beanContext;
    private Object oid;
    private String containerId;

    public StatefulBeanContextReference() {
    }

    public StatefulBeanContextReference(StatefulBeanContext beanContext) {
        this.beanContext = beanContext;
        this.oid = beanContext.getId();
        this.containerId = beanContext.getContainer().getObjectName().getCanonicalName();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerId = in.readUTF();
        this.oid = in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerId);
        out.writeObject(this.oid);
    }

    public StatefulBeanContext getBeanContext() {
        if (this.beanContext == null) {
            StatefulContainer container = (StatefulContainer)Ejb3Registry.getContainer(this.containerId);
            this.beanContext = container.getCache().get(this.oid, false);
        }
        return this.beanContext;
    }
}

