/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.ResourceAdapter;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.jms.JMSDestinationFactory;
import org.jboss.ejb3.mdb.ActivationSpec;
import org.jboss.ejb3.mdb.MDBContext;
import org.jboss.ejb3.mdb.inflow.JBossMessageEndpointFactory;
import org.jboss.ejb3.timerservice.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.TimerServiceFactory;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.mx.util.ObjectNameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessagingContainer
extends EJBContainer
implements TimedObjectInvoker {
    private static final Logger log = Logger.getLogger(MessagingContainer.class);
    protected TimerService timerService;
    protected ActivationSpec activationSpec = new ActivationSpec();
    protected JBossMessageEndpointFactory messageEndpointFactory;
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
    protected static final String JMS_ADAPTOR = "jms-ra.rar";
    protected static final String DESTINATION = "destination";
    protected static final String DESTINATION_TYPE = "destinationType";
    protected static final String PROVIDER_ADAPTER_JNDI = "providerAdapterJNDI";
    protected static final String MAX_SESSION = "maxSession";

    public MessagingContainer(String ejbName, AspectManager manager, ClassLoader cl, String beanClassName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super("jboss.j2ee:service=EJB3,name=" + ejbName, manager, cl, beanClassName, ejbName, ctxProperties, interceptorRepository, deployment);
        this.beanContextClass = MDBContext.class;
        this.messageEndpointFactory = new JBossMessageEndpointFactory();
        this.messageEndpointFactory.setContainer(this);
    }

    public abstract Class getMessagingType();

    public abstract Map getActivationConfigProperties();

    protected abstract void populateActivationSpec();

    @Override
    public abstract MethodInfo getMethodInfo(Method var1);

    public void setMessageEndpointFactory(JBossMessageEndpointFactory messageEndpointFactory) {
        this.messageEndpointFactory = messageEndpointFactory;
    }

    public String getResourceAdaptorName() {
        ResourceAdapter annotation = (ResourceAdapter)this.resolveAnnotation(ResourceAdapter.class);
        if (annotation == null) {
            return JMS_ADAPTOR;
        }
        return annotation.value();
    }

    protected void addActivationSpecProperty(Map result, ActivationConfigProperty property) {
        if (!property.propertyName().equals("messagingType")) {
            ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData();
            try {
                Field nameField = ActivationConfigPropertyMetaData.class.getDeclaredField("name");
                nameField.setAccessible(true);
                nameField.set(metaData, property.propertyName());
                Field valueField = ActivationConfigPropertyMetaData.class.getDeclaredField("value");
                valueField.setAccessible(true);
                valueField.set(metaData, property.propertyValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            result.put(property.propertyName(), metaData);
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.populateActivationSpec();
        this.innerStart();
        this.timerService = TimerServiceFactory.getInstance().createTimerService(this.getObjectName(), this);
        this.startProxies();
        TimerServiceFactory.getInstance().restoreTimerService(this.timerService);
    }

    protected void innerStart() throws Exception {
        log.debug("Initializing");
    }

    public ObjectName getJmxName() {
        ObjectName jmxName = null;
        String jndiName = ProxyFactoryHelper.getLocalJndiName(this);
        String name = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
        try {
            jmxName = ObjectNameConverter.convert(name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create ObjectName, msg=" + e.getMessage());
        }
        return jmxName;
    }

    protected void startProxies() throws Exception {
        this.messageEndpointFactory.start();
    }

    protected String parseJndiSuffix(String jndiname, String defautSuffix) {
        int indexOfSlash;
        String jndiSuffix = "";
        jndiSuffix = jndiname != null ? ((indexOfSlash = jndiname.indexOf("/")) != -1 ? jndiname.substring(indexOfSlash + 1) : jndiname) : defautSuffix;
        return jndiSuffix;
    }

    public Object localInvoke(Method method, Object[] args) throws Throwable {
        MethodInfo info = this.getMethodInfo(method);
        if (info == null) {
            throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
        }
        return this.localInvoke(info, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(MethodInfo info, Object[] args) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        this.pushEnc();
        try {
            EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info);
            nextInvocation.setAdvisor(this);
            nextInvocation.setArguments(args);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.popEnc();
        }
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public TimerService getTimerService(Object pKey) {
        assert (this.timerService != null) : "Timer Service not yet initialized";
        return this.timerService;
    }

    @Override
    public void callTimeout(Timer timer) throws Exception {
        Method timeout = this.callbackHandler.getTimeoutCallback();
        if (timeout == null) {
            throw new EJBException("No method has been annotated with @Timeout");
        }
        Object[] args = new Object[]{timer};
        try {
            this.localInvoke(timeout, args);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.timerService != null) {
            TimerServiceFactory.getInstance().removeTimerService(this.timerService);
            this.timerService = null;
        }
        this.stopProxies();
        super.stop();
    }

    protected void stopProxies() throws Exception {
        this.messageEndpointFactory.stop();
    }

    @Override
    protected void initializePool() throws Exception {
        super.initializePool();
        String maxSession = this.getMaxSession();
        if (maxSession != null) {
            this.pool.setMaxSize(Integer.parseInt(maxSession));
        }
    }

    protected String getProviderAdapterJNDI() {
        ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)this.getActivationConfigProperties().get(PROVIDER_ADAPTER_JNDI);
        if (property != null) {
            return property.getValue();
        }
        return "java:/DefaultJMSProvider";
    }

    protected String getMaxSession() {
        ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)this.getActivationConfigProperties().get(MAX_SESSION);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    protected String getDestination() {
        ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)this.getActivationConfigProperties().get(DESTINATION);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    protected String getDestinationType() {
        ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)this.getActivationConfigProperties().get(DESTINATION_TYPE);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    protected void jmsCreate() throws Exception {
        JMSProviderAdapter adapter = this.getJMSProviderAdapter();
        log.debug("Provider adapter: " + adapter);
        Context context = adapter.getInitialContext();
        log.debug("context: " + context);
        if (context == null) {
            throw new RuntimeException("Failed to get the root context");
        }
        String destinationType = this.getDestinationType();
        if (destinationType == null) {
            log.warn("No message-driven-destination given; using; guessing type");
            destinationType = this.getDestinationType(context, this.getDestination());
        }
        if (DEFAULT_DESTINATION_TYPE.equals(destinationType)) {
            this.innerCreateTopic(context);
        } else if ("javax.jms.Queue".equals(destinationType)) {
            this.innerCreateQueue(context);
        } else {
            throw new DeploymentException("Unknown destination-type " + destinationType);
        }
        log.debug("Initialized with config " + this.toString());
        context.close();
    }

    protected void innerCreateQueue(Context context) throws Exception {
        log.debug("Got destination type Queue for " + this.ejbName);
        String jndiSuffix = this.parseJndiSuffix(this.getDestination(), this.ejbName);
        log.debug("jndiSuffix: " + jndiSuffix);
        Queue queue = null;
        try {
            if (this.getDestination() != null) {
                queue = (Queue)context.lookup(this.getDestination());
            }
        }
        catch (NamingException e) {
            log.warn("Could not find the queue destination-jndi-name=" + this.getDestination());
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a Queue destination-jndi-name=" + this.getDestination());
        }
        if (queue == null) {
            queue = (Queue)this.createDestination(Queue.class, context, "queue/" + jndiSuffix, jndiSuffix);
        }
    }

    protected void innerCreateTopic(Context context) throws Exception {
        log.debug("Got destination type Topic for " + this.ejbName);
        String jndiSuffix = this.parseJndiSuffix(this.getDestination(), this.ejbName);
        log.debug("jndiSuffix: " + jndiSuffix);
        Topic topic = null;
        try {
            if (this.getDestination() != null) {
                topic = (Topic)context.lookup(this.getDestination());
            }
        }
        catch (NamingException e) {
            log.warn("Could not find the topic destination-jndi-name=" + this.getDestination());
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a Topic destination-jndi-name=" + this.getDestination());
        }
        if (topic == null) {
            topic = (Topic)this.createDestination(Topic.class, context, "topic/" + jndiSuffix, jndiSuffix);
        }
    }

    private Destination createDestination(Class<? extends Destination> type, Context ctx, String jndiName, String jndiSuffix) throws Exception {
        try {
            return (Destination)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            if (this.getDestination() == null) {
                return null;
            }
            log.warn("destination not found: " + jndiName + " reason: " + e);
            log.warn("creating a new temporary destination: " + jndiName);
            this.createTemporaryDestination(type, jndiSuffix);
            return (Destination)ctx.lookup(jndiName);
        }
    }

    private void createTemporaryDestination(Class<? extends Destination> type, String jndiSuffix) throws Exception {
        JMSDestinationFactory.getInstance().createDestination(type, jndiSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSProviderAdapter getJMSProviderAdapter() throws NamingException {
        InitialContext context = this.getInitialContext();
        String providerAdapterJNDI = this.getProviderAdapterJNDI();
        try {
            log.debug("Looking up provider adapter: " + providerAdapterJNDI);
            JMSProviderAdapter jMSProviderAdapter = (JMSProviderAdapter)context.lookup(providerAdapterJNDI);
            return jMSProviderAdapter;
        }
        finally {
            context.close();
        }
    }

    protected String getDestinationType(Context ctx, String destinationJNDI) {
        String destType = null;
        if (destinationJNDI != null) {
            try {
                Destination dest = (Destination)ctx.lookup(destinationJNDI);
                if (dest instanceof Topic) {
                    destType = DEFAULT_DESTINATION_TYPE;
                } else if (dest instanceof Queue) {
                    destType = "javax.jms.Queue";
                }
            }
            catch (NamingException ex) {
                log.debug("Could not do heristic lookup of destination ", ex);
            }
        }
        if (destType == null) {
            log.warn("Could not determine destination type, defaults to: javax.jms.Topic");
            destType = DEFAULT_DESTINATION_TYPE;
        }
        return destType;
    }
}

