/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.IOException;
import org.jboss.deployers.plugins.deployers.helpers.ObjectModelFactoryDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.ejb3.metamodel.ApplicationClientDD;
import org.jboss.ejb3.metamodel.JBossClientDDObjectFactory;
import org.jboss.util.xml.DOMUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossClientParsingDeployer
extends ObjectModelFactoryDeployer<ApplicationClientDD> {
    private String jbossClientXmlPath = "jboss-client.xml";

    public JBossClientParsingDeployer() {
        super(ApplicationClientDD.class);
        this.setRelativeOrder(2001);
    }

    protected boolean allowsReparse() {
        return true;
    }

    protected ObjectModelFactory getObjectModelFactory(ApplicationClientDD root) {
        if (root == null) {
            root = new ApplicationClientDD();
        }
        return new JBossClientDDObjectFactory(root);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (this.accepts(unit)) {
            this.createMetaData(unit, this.jbossClientXmlPath, null);
        }
    }

    private boolean accepts(DeploymentUnit unit) throws DeploymentException {
        boolean accepts = false;
        VirtualFile dd = unit.getMetaDataFile(this.jbossClientXmlPath);
        if (dd != null) {
            this.log.debug("Found application-client.xml file: " + unit.getName());
            try {
                Element root = DOMUtils.parse(dd.openStream());
                DocumentType doctype = root.getOwnerDocument().getDoctype();
                String publicId = doctype != null ? doctype.getPublicId() : null;
                accepts = "-//JBoss//DTD Application Client 5.0//EN".equals(publicId);
                if (!accepts) {
                    this.log.debug("Ignore jboss-client.xml with publicId: " + publicId);
                }
            }
            catch (IOException ex) {
                DeploymentException.rethrowAsDeploymentException((String)("Cannot parse " + this.jbossClientXmlPath), (Throwable)ex);
            }
        }
        return accepts;
    }
}

