/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.plugins.deployers.helpers.AbstractTypedDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.ejb3.metamodel.ApplicationClientDD;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientScanningDeployer
extends AbstractTypedDeployer<ApplicationClientDD> {
    public AppClientScanningDeployer() {
        super(ApplicationClientDD.class);
        this.setRelativeOrder(5000);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        ApplicationClientDD dd = (ApplicationClientDD)unit.getAttachment(this.getDeploymentType());
        if (dd != null) {
            return;
        }
        try {
            String mainClassName = this.getMainClassName(unit);
            if (mainClassName == null) {
                return;
            }
            Class<?> mainClass = unit.getClassLoader().loadClass(mainClassName);
            this.log.info("mainClass = " + mainClass);
            if (this.hasAnnotations(mainClass)) {
                dd = new ApplicationClientDD();
                unit.addAttachment(ApplicationClientDD.class, (Object)dd);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMainClassName(DeploymentUnit unit) throws IOException {
        VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
        this.log.trace("parsing " + file);
        if (file == null) {
            return null;
        }
        try {
            String className;
            Manifest mf;
            InputStream is = file.openStream();
            try {
                mf = new Manifest(is);
            }
            finally {
                is.close();
            }
            Attributes attrs = mf.getMainAttributes();
            String string = className = attrs.getValue(Attributes.Name.MAIN_CLASS);
            return string;
        }
        finally {
            file.close();
        }
    }

    private boolean hasAnnotations(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (cls.getAnnotations().length > 0) {
            return true;
        }
        for (Field f : cls.getDeclaredFields()) {
            if (f.getAnnotations().length <= 0) continue;
            return true;
        }
        return this.hasAnnotations(cls.getSuperclass());
    }
}

