/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.jboss.client.AppClientLauncher;
import org.jboss.ejb3.client.ClientContainer;
import org.jboss.ejb3.metamodel.ApplicationClientDD;
import org.jboss.ejb3.metamodel.ApplicationClientDDObjectFactory;
import org.jboss.ejb3.metamodel.JBossClientDDObjectFactory;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.xb.binding.JBossXBException;

public class ClientLauncher
implements AppClientLauncher {
    private static final Logger log = Logger.getLogger(ClientLauncher.class);

    private static URL findResource(String resourceName) {
        URL url = Thread.currentThread().getContextClassLoader() instanceof URLClassLoader ? ((URLClassLoader)Thread.currentThread().getContextClassLoader()).findResource(resourceName) : Thread.currentThread().getContextClassLoader().getResource(resourceName);
        return url;
    }

    public static void launch(ApplicationClientDD xml, String mainClassName, String applicationClientName, String[] args) throws Exception {
        Class<?> mainClass = Class.forName(mainClassName);
        ClientContainer container = new ClientContainer(xml, mainClass, applicationClientName);
        container.invokeMain(args);
    }

    public static ApplicationClientDD loadXML() throws JBossXBException, IOException {
        URL url = ClientLauncher.findResource("META-INF/application-client.xml");
        log.trace("application-client.xml found at " + url);
        URL jbossClientURL = ClientLauncher.findResource("META-INF/jboss-client.xml");
        log.trace("jboss-client.xml found at " + jbossClientURL);
        return ClientLauncher.loadXML(url, jbossClientURL);
    }

    @Deprecated
    public static ApplicationClientDD loadXML(String urlSpec) throws JBossXBException, IOException {
        URL url = new URL(urlSpec);
        return ClientLauncher.loadXML(url, null);
    }

    public static ApplicationClientDD loadXML(URL url, URL jbossClientURL) throws JBossXBException, IOException {
        ApplicationClientDD dd = ApplicationClientDDObjectFactory.parse(url);
        dd = JBossClientDDObjectFactory.parse(jbossClientURL, dd);
        return dd;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("expected a jar filename as argument");
            }
            String name = args[0];
            if (name.endsWith(".jar")) {
                throw new NotImplementedException();
            }
            String mainClassName = name;
            Class<?> mainClass = Class.forName(mainClassName);
            URL appXmlURL = mainClass.getClassLoader().getResource("META-INF/application-client.xml");
            if (appXmlURL == null) {
                throw new RuntimeException("Can't find META-INF/application-client.xml");
            }
            ApplicationClientDD xml = ApplicationClientDDObjectFactory.parse(appXmlURL);
            ArrayList<String> newArgs = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                newArgs.add(args[i]);
            }
            args = newArgs.toArray(args);
            String mainClassName2 = name;
            ClientLauncher.launch(xml, mainClassName2, "FIXME", args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void launch(String mainClassName, String clientName, String[] args) throws Throwable {
        ApplicationClientDD xml = ClientLauncher.loadXML();
        ClientLauncher.launch(xml, mainClassName, clientName, args);
    }
}

