/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.annotation.ejb.cache.tree.CacheConfig;
import org.jboss.aop.Advisor;
import org.jboss.cache.AbstractCacheListener;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheListener;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Region;
import org.jboss.cache.config.Option;
import org.jboss.cache.eviction.EvictionPolicyConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.cache.tree.AbortableLRUPolicy;
import org.jboss.ejb3.cache.tree.ContextInUseException;
import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
import org.jboss.ejb3.stateful.ProxiedStatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.id.GUID;

public class StatefulTreeCache
implements ClusteredStatefulCache {
    private static final int FQN_SIZE = 3;
    private static final int DEFAULT_BUCKET_COUNT = 100;
    private static final String[] DEFAULT_HASH_BUCKETS = new String[100];
    private static Option BYPASS_OPTION = new Option();
    private static Option LOCAL_ONLY_OPTION = new Option();
    private static Option GRAVITATE_OPTION = new Option();
    private ThreadLocal<Boolean> localActivity = new ThreadLocal();
    private Logger log = Logger.getLogger(StatefulTreeCache.class);
    private Pool pool;
    private WeakReference<ClassLoader> classloader;
    private Cache cache;
    private Fqn cacheNode;
    private Region region;
    private ClusteredStatefulCacheListener listener;
    public static long MarkInUseWaitTime;
    protected String[] hashBuckets = DEFAULT_HASH_BUCKETS;
    protected long removalTimeout = 0L;
    protected RemovalTimeoutTask removalTask = null;
    protected boolean running = true;
    protected Map<Object, Long> beans = new ConcurrentHashMap<Object, Long>();
    protected Container container;

    public StatefulBeanContext create() {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Caching context " + ctx.getId() + " of type " + ctx.getClass());
            }
            this.putInCache(ctx);
            ctx.setInUse(true);
            ctx.lastUsed = System.currentTimeMillis();
            this.beans.put(ctx.getId(), ctx.lastUsed);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Caching context " + ctx.getId() + " of type " + ctx.getClass());
            }
            this.putInCache(ctx);
            ctx.setInUse(true);
            ctx.lastUsed = System.currentTimeMillis();
            this.beans.put(ctx.getId(), ctx.lastUsed);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        Fqn id = this.getFqn(key, false);
        Boolean active = this.localActivity.get();
        try {
            this.localActivity.set(Boolean.TRUE);
            InvocationContext ictx = this.cache.getInvocationContext();
            ictx.setOptionOverrides(StatefulTreeCache.getGravitateOption());
            entry = (StatefulBeanContext)this.cache.get(id, (Object)"bean");
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
        finally {
            this.localActivity.set(active);
        }
        if (entry == null) {
            throw new NoSuchEJBException("Could not find stateful bean: " + key);
        }
        if (markInUse && entry.isRemoved()) {
            throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed)");
        }
        entry.postReplicate();
        if (markInUse) {
            entry.setInUse(true);
            this.region.markNodeCurrentlyInUse(new Fqn((Object)key.toString()), MarkInUseWaitTime);
            entry.lastUsed = System.currentTimeMillis();
            this.beans.put(key, entry.lastUsed);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("get: retrieved bean with cache id " + id.toString());
        }
        return entry;
    }

    public void remove(Object key) {
        Fqn id = this.getFqn(key, false);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("remove: cache id " + id.toString());
            }
            InvocationContext ictx = this.cache.getInvocationContext();
            ictx.setOptionOverrides(StatefulTreeCache.getGravitateOption());
            StatefulBeanContext ctx = (StatefulBeanContext)this.cache.get(id, (Object)"bean");
            if (ctx != null) {
                if (!ctx.isRemoved()) {
                    this.pool.remove(ctx);
                }
                if (ctx.getCanRemoveFromCache()) {
                    this.cache.removeNode(id);
                }
                this.beans.remove(key);
            }
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
            this.beans.put(ctx.getId(), ctx.lastUsed);
            this.region.unmarkNodeCurrentlyInUse(this.getFqn(ctx.getId(), true));
        }
    }

    public void replicate(StatefulBeanContext ctx) {
        if (ctx instanceof NestedStatefulBeanContext) {
            throw new IllegalArgumentException("Received unexpected replicate call for nested context " + ctx.getId());
        }
        try {
            this.putInCache(ctx);
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
    }

    public void initialize(Container container) throws Exception {
        this.log = Logger.getLogger(this.getClass().getName() + "." + container.getEjbName());
        this.container = container;
        this.pool = container.getPool();
        ClassLoader cl = ((EJBContainer)container).getClassloader();
        this.classloader = new WeakReference<ClassLoader>(cl);
        Advisor advisor = (Advisor)((Object)container);
        CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
        MBeanServer server = MBeanServerLocator.locateJBoss();
        ObjectName cacheON = new ObjectName(config.name());
        CacheJmxWrapperMBean mbean = (CacheJmxWrapperMBean)MBeanProxyExt.create(CacheJmxWrapperMBean.class, cacheON, server);
        this.cache = mbean.getCache();
        this.cacheNode = Fqn.fromString((String)("/" + container.getEjbName() + "/"));
        this.region = this.cache.getRegion(this.cacheNode, true);
        EvictionPolicyConfig epc = this.getEvictionPolicyConfig((int)config.idleTimeoutSeconds(), config.maxSize());
        this.region.setEvictionPolicy(epc);
        this.region.registerContextClassLoader(cl);
        this.region.activate();
        this.log.debug("initialize(): created region: " + this.region + " for ejb: " + container.getEjbName());
        this.removalTimeout = config.removalTimeoutSeconds();
        if (this.removalTimeout > 0L) {
            this.removalTask = new RemovalTimeoutTask("SFSB Removal Thread - " + container.getObjectName().getCanonicalName());
        }
    }

    protected EvictionPolicyConfig getEvictionPolicyConfig(int timeToLiveSeconds, int maxNodes) {
        LRUConfiguration epc = new LRUConfiguration();
        epc.setEvictionPolicyClass(AbortableLRUPolicy.class.getName());
        epc.setTimeToLiveSeconds(timeToLiveSeconds);
        epc.setMaxNodes(maxNodes);
        return epc;
    }

    public void start() {
        this.listener = new ClusteredStatefulCacheListener();
        this.cache.addCacheListener((CacheListener)this.listener);
        if (this.removalTask != null) {
            this.removalTask.start();
        }
        this.running = true;
    }

    public void stop() {
        this.running = false;
        this.cache.removeCacheListener((CacheListener)this.listener);
        try {
            InvocationContext ctx = this.cache.getInvocationContext();
            ctx.setOptionOverrides(StatefulTreeCache.getLocalOnlyOption());
            this.cache.removeNode(this.cacheNode);
        }
        catch (CacheException e) {
            this.log.error("stop(): can't remove bean from the underlying distributed cache");
        }
        if (this.region != null) {
            this.region.deactivate();
            this.region.unregisterContextClassLoader();
            ((CacheSPI)this.cache).getRegionManager().removeRegion(this.region.getFqn());
            this.region.resetEvictionQueues();
            this.region = null;
        }
        this.classloader = null;
        if (this.removalTask != null) {
            this.removalTask.interrupt();
        }
        this.log.debug("stop(): StatefulTreeCache stopped successfully for " + this.cacheNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(StatefulBeanContext ctx) {
        Boolean active = this.localActivity.get();
        try {
            this.localActivity.set(Boolean.TRUE);
            ctx.preReplicate();
            this.cache.put(this.getFqn(ctx.getId(), false), (Object)"bean", (Object)ctx);
            ctx.markedForReplication = false;
        }
        finally {
            this.localActivity.set(active);
        }
    }

    private Fqn getFqn(Object id, boolean regionRelative) {
        String beanId = id.toString();
        int index = id instanceof GUID ? (id.hashCode() & Integer.MAX_VALUE) % this.hashBuckets.length : (beanId.hashCode() & Integer.MAX_VALUE) % this.hashBuckets.length;
        if (regionRelative) {
            return new Fqn(new Object[]{this.hashBuckets[index], beanId});
        }
        return new Fqn(this.cacheNode, (Object)this.hashBuckets[index], (Object)beanId);
    }

    private RuntimeException convertToRuntimeException(CacheException e) {
        RuntimeException re = new RuntimeException(((Object)((Object)e)).getClass().getName() + " " + e.getMessage());
        re.setStackTrace(e.getStackTrace());
        return re;
    }

    private static Option getBypassOption() {
        try {
            return BYPASS_OPTION.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Option getLocalOnlyOption() {
        try {
            return LOCAL_ONLY_OPTION.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Option getGravitateOption() {
        try {
            return GRAVITATE_OPTION.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        BYPASS_OPTION.setBypassInterceptorChain(true);
        LOCAL_ONLY_OPTION.setCacheModeLocal(true);
        GRAVITATE_OPTION.setForceDataGravitation(true);
        for (int i = 0; i < DEFAULT_HASH_BUCKETS.length; ++i) {
            StatefulTreeCache.DEFAULT_HASH_BUCKETS[i] = String.valueOf(i);
        }
        MarkInUseWaitTime = 15000L;
    }

    private class RemovalTimeoutTask
    extends Thread {
        public RemovalTimeoutTask(String name) {
            super(name);
        }

        public void run() {
            while (StatefulTreeCache.this.running) {
                try {
                    Thread.sleep(StatefulTreeCache.this.removalTimeout * 1000L);
                }
                catch (InterruptedException e) {
                    StatefulTreeCache.this.running = false;
                    return;
                }
                try {
                    long now = System.currentTimeMillis();
                    for (Map.Entry<Object, Long> entry : StatefulTreeCache.this.beans.entrySet()) {
                        long lastUsed = entry.getValue();
                        if (now - lastUsed < StatefulTreeCache.this.removalTimeout * 1000L) continue;
                        StatefulTreeCache.this.remove(entry.getKey());
                    }
                }
                catch (Exception ex) {
                    StatefulTreeCache.this.log.error("problem removing SFSB thread", ex);
                }
            }
        }
    }

    public class ClusteredStatefulCacheListener
    extends AbstractCacheListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeLoaded(Fqn fqn, boolean pre, Map nodeData) {
            if (pre) {
                return;
            }
            if (nodeData == null) {
                return;
            }
            if (fqn.size() != 3) {
                return;
            }
            if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                return;
            }
            if (Boolean.TRUE != StatefulTreeCache.this.localActivity.get()) {
                return;
            }
            StatefulBeanContext bean = (StatefulBeanContext)nodeData.get("bean");
            if (bean == null) {
                throw new IllegalStateException("nodeLoaded(): null bean instance.");
            }
            if (StatefulTreeCache.this.log.isTraceEnabled()) {
                StatefulTreeCache.this.log.trace("nodeLoaded(): send postActivate event to bean at fqn: " + fqn);
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                bean.activateAfterReplication();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodePassivated(Fqn fqn, boolean pre) {
            block19: {
                if (!pre) {
                    return;
                }
                if (fqn.size() != 3) {
                    return;
                }
                if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                    return;
                }
                StatefulBeanContext bean = null;
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                Boolean active = (Boolean)StatefulTreeCache.this.localActivity.get();
                try {
                    StatefulTreeCache.this.localActivity.set(Boolean.TRUE);
                    InvocationContext ctx = StatefulTreeCache.this.cache.getInvocationContext();
                    ctx.setOptionOverrides(StatefulTreeCache.getBypassOption());
                    bean = (StatefulBeanContext)StatefulTreeCache.this.cache.get(fqn, (Object)"bean");
                    if (bean != null) {
                        ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
                        if (cl != null) {
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        if (!bean.getCanPassivate()) {
                            throw new ContextInUseException("Cannot passivate bean " + fqn + " -- it or one if its children is currently in use");
                        }
                        if (StatefulTreeCache.this.log.isTraceEnabled()) {
                            StatefulTreeCache.this.log.trace("nodePassivated(): send prePassivate event to bean at fqn: " + fqn);
                        }
                        bean.passivateAfterReplication();
                    }
                }
                catch (CacheException e) {
                    StatefulTreeCache.this.log.error("nodePassivate(): can't retrieve bean instance from: " + fqn + " with exception: " + (Object)((Object)e));
                    return;
                }
                catch (NoSuchEJBException e) {
                    if (bean instanceof ProxiedStatefulBeanContext) {
                        try {
                            bean.getContainedIn();
                            throw e;
                        }
                        catch (NoSuchEJBException n) {
                            StatefulTreeCache.this.log.debug("nodePassivated(): removing orphaned proxy at " + fqn);
                            try {
                                StatefulTreeCache.this.cache.removeNode(fqn);
                            }
                            catch (CacheException c) {
                                StatefulTreeCache.this.log.error("nodePassivated(): could not remove orphaned proxy at " + fqn, c);
                            }
                            break block19;
                        }
                    }
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                    StatefulTreeCache.this.localActivity.set(active);
                }
            }
        }
    }
}

