/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.ejb3.EJB3DeployerMBean;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.Ejb3Module;
import org.jboss.ejb3.JarsIgnoredForScanningMBean;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ClassFileFilter;
import org.w3c.dom.Element;

public class EJB3Deployer
extends SubDeployerSupport
implements SubDeployer,
EJB3DeployerMBean {
    private static final Logger log = Logger.getLogger(EJB3Deployer.class);
    private ServiceControllerMBean serviceController;
    private HashMap deployments = new HashMap();
    private SubDeployer thisProxy;
    private Properties DefaultProperties;
    private boolean deployEjb3ExtensionOnly;
    private HashSet ignoredJarsSet;
    private HashMap<DeploymentInfo, String> jmxNames = new HashMap();

    public EJB3Deployer() {
        this.setSuffixes(new String[]{".jar", ".ejb3", ".par"});
        this.setRelativeOrder(400);
    }

    public static boolean hasFile(DeploymentInfo di, String filePath) {
        String urlStr = di.url.getFile();
        try {
            URL dd = di.localCl.findResource(filePath);
            if (dd != null) {
                String ddStr;
                if (di.localUrl != null) {
                    urlStr = di.localUrl.toString();
                }
                if ((ddStr = dd.toString()).indexOf(urlStr) >= 0) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasPersistenceXml(DeploymentInfo di) {
        return EJB3Deployer.hasFile(di, "META-INF/persistence.xml");
    }

    public static boolean has30EjbJarXml(DeploymentInfo di) {
        if (!EJB3Deployer.hasFile(di, "META-INF/ejb-jar.xml")) {
            return false;
        }
        InputStream ddStream = di.localCl.getResourceAsStream("META-INF/ejb-jar.xml");
        return EJB3Deployer.has30EjbJarXml(ddStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean has30EjbJarXml(InputStream ddStream) {
        try {
            byte[] stringToFind = "version=\"3.0\"".getBytes();
            InputStreamReader reader = new InputStreamReader(ddStream);
            try {
                int idx = 0;
                int len = stringToFind.length;
                while (reader.ready()) {
                    int read = reader.read();
                    if (read == stringToFind[idx]) {
                        if (++idx != len) continue;
                        boolean bl = true;
                        return bl;
                    }
                    idx = 0;
                }
                return false;
            }
            finally {
                try {
                    reader.close();
                    ddStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean hasOnlyJbossXml(DeploymentInfo di) {
        return !EJB3Deployer.hasFile(di, "META-INF/ejb-jar.xml") && EJB3Deployer.hasFile(di, "META-INF/jboss.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasEjbAnnotation(DeploymentInfo di) {
        Iterator it = ArchiveBrowser.getBrowser(di.url, new ClassFileFilter());
        try {
            while (it.hasNext()) {
                InputStream stream = (InputStream)it.next();
                DataInputStream dstream = new DataInputStream(new BufferedInputStream(stream));
                ClassFile cf = null;
                try {
                    cf = new ClassFile(dstream);
                    AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
                    if (visible == null) continue;
                    if (EJB3Util.isStateless(visible)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (EJB3Util.isStatefulSession(visible)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (EJB3Util.isMessageDriven(visible)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (EJB3Util.isConsumer(visible)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (!EJB3Util.isService(visible)) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    dstream.close();
                    stream.close();
                }
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.getFile();
        if (urlStr.endsWith(".ejb3") || urlStr.endsWith(".ejb3/") || urlStr.endsWith(".par") || urlStr.endsWith(".par/")) {
            return true;
        }
        if (!urlStr.endsWith(".jar") && !urlStr.endsWith(".jar/")) {
            return false;
        }
        if (this.ignoredJarsSet.contains(di.shortName)) {
            return false;
        }
        if (EJB3Deployer.has30EjbJarXml(di)) {
            return true;
        }
        if (!this.deployEjb3ExtensionOnly) {
            if (EJB3Deployer.hasPersistenceXml(di)) {
                return true;
            }
            if (this.hasOnlyJbossXml(di)) {
                return true;
            }
            if (this.hasEjbAnnotation(di)) {
                return true;
            }
        }
        return false;
    }

    public Properties getDefaultProperties() {
        return this.DefaultProperties;
    }

    public void setJarsIgnoredForScanning(JarsIgnoredForScanningMBean mbean) {
        this.ignoredJarsSet = mbean.getIgnoredJarsSet();
    }

    public boolean getDeployEjb3ExtensionOnly() {
        return this.deployEjb3ExtensionOnly;
    }

    public void setDeployEjb3ExtensionOnly(boolean deployEjb3ExtensionOnly) {
        this.deployEjb3ExtensionOnly = deployEjb3ExtensionOnly;
    }

    protected void createService() throws Exception {
        URL propsUrl = this.getClass().getClassLoader().getResource("META-INF/persistence.properties");
        this.DefaultProperties = new Properties();
        this.DefaultProperties.load(propsUrl.openStream());
        log.debug("Default persistence.properties: " + this.DefaultProperties);
        String bcprovider = this.DefaultProperties.getProperty("hibernate.bytecode.provider", "javassist");
        System.setProperty("hibernate.bytecode.provider", bcprovider);
        super.createService();
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, this.server);
        this.thisProxy = (SubDeployer)MBeanProxyExt.create(SubDeployer.class, super.getServiceName(), super.getServer());
        this.mainDeployer.addDeployer(this.thisProxy);
        InitialContext iniCtx = new InitialContext();
        EJB3Deployer.initializeJavaComp(iniCtx);
    }

    public static void initializeJavaComp(InitialContext iniCtx) throws NamingException {
        Context ctx = (Context)iniCtx.lookup("java:");
        ctx.rebind("comp.ejb3", (Object)new LinkRef("java:comp"));
    }

    protected void stopService() throws Exception {
        for (DeploymentInfo di : this.deployments.values()) {
            this.stop(di);
        }
        for (DeploymentInfo di : new ArrayList(this.deployments.values())) {
            this.destroy(di);
        }
        this.deployments.clear();
        this.mainDeployer.removeDeployer(this.thisProxy);
        this.serviceController = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DeploymentInfo di) throws DeploymentException {
        block8: {
            try {
                File file;
                di.watch = di.url.getProtocol().equalsIgnoreCase("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/ejb-jar.xml")) : di.url;
                XmlFileLoader xfl = new XmlFileLoader();
                InputStream in = di.localCl.getResourceAsStream("META-INF/jboss.xml");
                if (in == null) break block8;
                try {
                    Element jmxNameElement;
                    Element jboss = xfl.getDocument(in, "META-INF/jboss.xml").getDocumentElement();
                    Element loader = MetaData.getOptionalChild(jboss, "loader-repository");
                    if (loader != null) {
                        LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig(loader);
                        di.setRepositoryInfo(config);
                    }
                    if ((jmxNameElement = MetaData.getOptionalChild(jboss, "jmx-name")) != null) {
                        this.jmxNames.put(di, jmxNameElement.getChildNodes().item(0).getNodeValue());
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                if (e instanceof DeploymentException) {
                    throw (DeploymentException)((Object)e);
                }
                throw new DeploymentException("failed to initialize", e);
            }
        }
        super.init(di);
    }

    public synchronized void create(DeploymentInfo di) throws DeploymentException {
        log.debug("create, " + di.shortName);
        try {
            ObjectName ejbModuleName;
            URL loaderURL = di.localUrl != null ? di.localUrl : di.url;
            di.annotationsCl = new URLClassLoader(new URL[]{loaderURL}, (ClassLoader)di.ucl);
            Ejb3Module ejbModule = new Ejb3Module(di);
            String name = this.jmxNames.get(di);
            if (name == null) {
                name = "jboss.j2ee:service=EJB3,module=" + di.shortName;
            }
            if (this.server.isRegistered(ejbModuleName = ObjectNameConverter.convert(name))) {
                log.debug("The EJBModule name: " + ejbModuleName + "is already registered, adding uid=" + System.identityHashCode(ejbModule));
                name = name + ",uid=" + System.identityHashCode(ejbModule);
                ejbModuleName = ObjectNameConverter.convert(name);
            }
            this.server.registerMBean(ejbModule, ejbModuleName);
            di.deployedObject = ejbModuleName;
            log.debug("Deploying: " + di.url);
            this.serviceController.create(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during create of EjbModule: " + di.url, e);
        }
        super.create(di);
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        try {
            log.debug("start application, deploymentInfo: " + di + ", short name: " + di.shortName + ", parent short name: " + (di.parent == null ? "null" : di.parent.shortName));
            this.serviceController.start(di.deployedObject);
            log.info("Deployed: " + di.url);
            this.deployments.put(di.url, di);
        }
        catch (Exception e) {
            this.stop(di);
            this.destroy(di);
            throw new DeploymentException("Could not deploy " + di.url, e);
        }
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        log.debug("init, " + di.shortName);
        try {
            this.serviceController.stop(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("problem stopping ejb module: " + di.url, e);
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.deployments.remove(di.url);
        try {
            this.serviceController.destroy(di.deployedObject);
            this.serviceController.remove(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("problem destroying ejb module: " + di.url, e);
        }
        this.jmxNames.remove(di);
        super.destroy(di);
    }
}

