/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EJBProxyFactoryContainer;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstancePoolContainer;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.SessionContainer;
import org.jboss.invocation.Invocation;
import org.jboss.util.UnreachableStatementException;

public class StatelessSessionContainer
extends SessionContainer
implements EJBProxyFactoryContainer,
InstancePoolContainer {
    public void remove(Invocation mi) throws RemoteException, RemoveException {
        this.log.debug("Useless invocation of remove() for stateless session bean");
    }

    public EJBLocalObject createLocalHome() throws CreateException {
        if (this.localProxyFactory == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        ++this.createCount;
        return this.localProxyFactory.getStatelessSessionEJBLocalObject();
    }

    public void removeLocalHome(Object primaryKey) {
        this.log.debug("Useless invocation of remove(Object) for stateless session bean");
    }

    public EJBObject createHome() throws RemoteException, CreateException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        ++this.createCount;
        Object obj = ci.getStatelessSessionEJBObject();
        return (EJBObject)obj;
    }

    public void removeHome(Handle handle) throws RemoteException, RemoveException {
        throw new UnreachableStatementException();
    }

    public void removeHome(Object primaryKey) throws RemoteException, RemoveException {
        throw new UnreachableStatementException();
    }

    protected void setupHomeMapping() throws NoSuchMethodException {
        int i;
        Method[] m;
        HashMap<Method, Method> map = new HashMap<Method, Method>();
        if (this.homeInterface != null) {
            m = this.homeInterface.getMethods();
            for (i = 0; i < m.length; ++i) {
                this.log.debug("Mapping " + m[i].getName());
                map.put(m[i], this.getClass().getMethod(m[i].getName() + "Home", m[i].getParameterTypes()));
            }
        }
        if (this.localHomeInterface != null) {
            m = this.localHomeInterface.getMethods();
            for (i = 0; i < m.length; ++i) {
                this.log.debug("Mapping " + m[i].getName());
                map.put(m[i], this.getClass().getMethod(m[i].getName() + "LocalHome", m[i].getParameterTypes()));
            }
        }
        this.homeMapping = map;
    }

    Interceptor createContainerInterceptor() {
        return new ContainerInterceptor();
    }

    class ContainerInterceptor
    extends Container.AbstractContainerInterceptor {
        ContainerInterceptor() {
        }

        public Object invokeHome(Invocation mi) throws Exception {
            Method miMethod = mi.getMethod();
            Method m = (Method)StatelessSessionContainer.this.getHomeMapping().get(miMethod);
            if (m == null) {
                String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
                throw new EJBException(msg);
            }
            try {
                return mi.performCall(StatelessSessionContainer.this, m, mi.getArguments());
            }
            catch (Exception e) {
                this.rethrow(e);
                throw new UnreachableStatementException();
            }
        }

        public Object invoke(Invocation mi) throws Exception {
            EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
            if (ctx.getTransaction() == null) {
                ctx.setTransaction(mi.getTransaction());
            }
            Method miMethod = mi.getMethod();
            Map map = StatelessSessionContainer.this.getBeanMapping();
            Method m = (Method)map.get(miMethod);
            if (m == null && map.values().contains(miMethod)) {
                m = miMethod;
            }
            if (m == null) {
                String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
                throw new EJBException(msg);
            }
            if (m.getDeclaringClass().equals(StatelessSessionContainer.class) || m.getDeclaringClass().equals(SessionContainer.class)) {
                try {
                    return mi.performCall(StatelessSessionContainer.this, m, new Object[]{mi});
                }
                catch (Exception e) {
                    this.rethrow(e);
                }
            } else {
                try {
                    Object bean = ctx.getInstance();
                    return mi.performCall(bean, m, mi.getArguments());
                }
                catch (Exception e) {
                    this.rethrow(e);
                }
            }
            throw new UnreachableStatementException();
        }
    }
}

