/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.util.Strings;

public final class EjbUtil50 {
    private static final Logger log = Logger.getLogger(EjbUtil50.class);

    public static String findEjbLink(MainDeployer server, DeploymentUnit unit, String link) {
        return EjbUtil50.resolveLink(server, unit, link, false);
    }

    public static String findLocalEjbLink(MainDeployer server, DeploymentUnit unit, String link) {
        return EjbUtil50.resolveLink(server, unit, link, true);
    }

    public static MessageDestinationMetaData findMessageDestination(MainDeployer server, DeploymentUnit di, String link) {
        return EjbUtil50.resolveMessageDestination(server, di, link);
    }

    private static String resolveLink(MainDeployer server, DeploymentUnit di, String link, boolean isLocal) {
        if (link == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("resolveLink( {" + di + "}, {" + link + "}, {" + isLocal + "}");
        }
        if (di == null) {
            return null;
        }
        if (link.indexOf(35) != -1) {
            return EjbUtil50.resolveRelativeLink(server, di, link, isLocal);
        }
        DeploymentUnit top = di;
        while (top.getDeploymentContext().getParent() != null) {
            top = top.getDeploymentContext().getParent().getDeploymentUnit();
        }
        return EjbUtil50.resolveAbsoluteLink(top, link, isLocal);
    }

    private static String resolveRelativeLink(MainDeployer server, DeploymentUnit unit, String link, boolean isLocal) {
        String path = link.substring(0, link.indexOf(35));
        String ejbName = link.substring(link.indexOf(35) + 1);
        String us = unit.getName();
        if (us.charAt(us.length() - 1) == '/') {
            us = us.substring(0, us.length() - 1);
        }
        String ourPath = us.substring(0, us.lastIndexOf(47));
        if (log.isTraceEnabled()) {
            log.trace("Resolving relative link: " + link);
            log.trace("Looking for: '" + link + "', we're located at: '" + ourPath + "'");
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("..")) {
                ourPath = ourPath.substring(0, ourPath.lastIndexOf(47));
                continue;
            }
            ourPath = ourPath + "/" + s;
        }
        URL target = null;
        try {
            target = Strings.toURL(ourPath);
        }
        catch (MalformedURLException mue) {
            log.warn("Can't construct URL for: " + ourPath);
            return null;
        }
        DeploymentUnit targetUnit = null;
        try {
            DeploymentContext ctx = server.getDeploymentContext(target.toString());
            targetUnit = ctx.getDeploymentUnit();
        }
        catch (Exception e) {
            log.warn("Got Exception when looking for DeploymentUnit: " + e);
            return null;
        }
        if (targetUnit == null) {
            log.warn("Can't locate DeploymentUnit for target: " + target);
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Found appropriate DeploymentUnit: " + targetUnit);
        }
        String linkTarget = null;
        if (targetUnit.getAttachment(ApplicationMetaData.class) != null) {
            ApplicationMetaData appMD = (ApplicationMetaData)targetUnit.getAttachment(ApplicationMetaData.class);
            BeanMetaData beanMD = appMD.getBeanByEjbName(ejbName);
            if (beanMD != null) {
                linkTarget = EjbUtil50.getJndiName(beanMD, isLocal);
            } else {
                log.warn("No Bean named '" + ejbName + "' found in '" + path + "'!");
            }
        } else {
            log.warn("DeploymentUnit " + targetUnit + " is not an EJB .jar " + "file!");
        }
        return linkTarget;
    }

    private static String resolveAbsoluteLink(DeploymentUnit unit, String link, boolean isLocal) {
        if (log.isTraceEnabled()) {
            log.trace("Resolving absolute link, di: " + unit);
        }
        String ejbName = null;
        if (unit.getAttachment(ApplicationMetaData.class) != null) {
            ApplicationMetaData appMD = (ApplicationMetaData)unit.getAttachment(ApplicationMetaData.class);
            BeanMetaData beanMD = appMD.getBeanByEjbName(link);
            if (beanMD != null) {
                ejbName = EjbUtil50.getJndiName(beanMD, isLocal);
                if (log.isTraceEnabled()) {
                    log.trace("Found Bean: " + beanMD + ", resolves to: " + ejbName);
                }
                return ejbName;
            }
            if (log.isTraceEnabled()) {
                log.trace("No match for ejb-link: " + link + ", module names:");
                Iterator iter = appMD.getEnterpriseBeans();
                while (iter.hasNext()) {
                    beanMD = (BeanMetaData)iter.next();
                    String beanEjbName = EjbUtil50.getJndiName(beanMD, isLocal);
                    log.trace("... ejbName: " + beanEjbName);
                }
            }
        }
        Iterator it = unit.getDeploymentContext().getChildren().iterator();
        while (it.hasNext() && ejbName == null) {
            DeploymentUnit child = ((DeploymentContext)it.next()).getDeploymentUnit();
            ejbName = EjbUtil50.resolveAbsoluteLink(child, link, isLocal);
        }
        return ejbName;
    }

    private static String getJndiName(BeanMetaData beanMD, boolean isLocal) {
        String jndiName = null;
        if (isLocal) {
            String localHome = beanMD.getLocalHome();
            if (localHome != null) {
                jndiName = beanMD.getLocalJndiName();
            } else {
                log.warn("LocalHome jndi name requested for: '" + beanMD.getEjbName() + "' but there is no LocalHome class");
            }
        } else {
            jndiName = beanMD.getJndiName();
        }
        return jndiName;
    }

    private static MessageDestinationMetaData resolveMessageDestination(MainDeployer server, DeploymentUnit di, String link) {
        if (link == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("resolveLink( {" + di + "}, {" + link + "})");
        }
        if (di == null) {
            return null;
        }
        if (link.indexOf(35) != -1) {
            return EjbUtil50.resolveRelativeMessageDestination(server, di, link);
        }
        DeploymentUnit top = di;
        while (top.getDeploymentContext().getParent() != null) {
            top = top.getDeploymentContext().getParent().getDeploymentUnit();
        }
        return EjbUtil50.resolveAbsoluteMessageDestination(top, link);
    }

    private static MessageDestinationMetaData resolveRelativeMessageDestination(MainDeployer server, DeploymentUnit unit, String link) {
        String path = link.substring(0, link.indexOf(35));
        String destinationName = link.substring(link.indexOf(35) + 1);
        String us = unit.getName();
        if (us.charAt(us.length() - 1) == '/') {
            us = us.substring(0, us.length() - 1);
        }
        String ourPath = us.substring(0, us.lastIndexOf(47));
        if (log.isTraceEnabled()) {
            log.trace("Resolving relative message-destination-link: " + link);
            log.trace("Looking for: '" + link + "', we're located at: '" + ourPath + "'");
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("..")) {
                ourPath = ourPath.substring(0, ourPath.lastIndexOf(47));
                continue;
            }
            ourPath = ourPath + "/" + s;
        }
        URL target = null;
        try {
            target = Strings.toURL(ourPath);
        }
        catch (MalformedURLException mue) {
            log.warn("Can't construct URL for: " + ourPath);
            return null;
        }
        DeploymentUnit targetUnit = null;
        try {
            DeploymentContext ctx = server.getDeploymentContext(target.toString());
            targetUnit = ctx.getDeploymentUnit();
        }
        catch (Exception e) {
            log.warn("Got Exception when looking for DeploymentUnit: " + e);
            return null;
        }
        if (targetUnit == null) {
            log.warn("Can't locate DeploymentUnit for target: " + target);
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Found appropriate DeploymentUnit: " + targetUnit);
        }
        if (targetUnit.getAttachment(ApplicationMetaData.class) != null) {
            ApplicationMetaData appMD = (ApplicationMetaData)targetUnit.getAttachment(ApplicationMetaData.class);
            return appMD.getMessageDestination(destinationName);
        }
        if (targetUnit.getAttachment(WebMetaData.class) != null) {
            WebMetaData webMD = (WebMetaData)targetUnit.getAttachment(WebMetaData.class);
            return webMD.getMessageDestination(destinationName);
        }
        log.warn("DeploymentUnit " + targetUnit + " is not an EJB .jar " + "file!");
        return null;
    }

    private static MessageDestinationMetaData resolveAbsoluteMessageDestination(DeploymentUnit unit, String link) {
        ApplicationMetaData appMD;
        MessageDestinationMetaData mdMD;
        if (log.isTraceEnabled()) {
            log.trace("Resolving absolute link, di: " + unit);
        }
        if (unit.getAttachment(ApplicationMetaData.class) != null && (mdMD = (appMD = (ApplicationMetaData)unit.getAttachment(ApplicationMetaData.class)).getMessageDestination(link)) != null) {
            return mdMD;
        }
        if (unit.getAttachment(WebMetaData.class) != null) {
            WebMetaData webMD = (WebMetaData)unit.getAttachment(WebMetaData.class);
            return webMD.getMessageDestination(link);
        }
        Iterator it = unit.getDeploymentContext().getChildren().iterator();
        while (it.hasNext()) {
            DeploymentUnit child = ((DeploymentContext)it.next()).getDeploymentUnit();
            MessageDestinationMetaData mdMD2 = EjbUtil50.resolveAbsoluteMessageDestination(child, link);
            if (mdMD2 == null) continue;
            return mdMD2;
        }
        return null;
    }
}

