/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.deployment.WebModuleMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.IconMetaData;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class J2eeApplicationObjectFactory
implements ObjectModelFactory {
    private static Logger log = Logger.getLogger(J2eeApplicationObjectFactory.class);

    public J2eeApplicationMetaData newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        J2eeApplicationMetaData metaData = null;
        metaData = root != null ? (J2eeApplicationMetaData)root : new J2eeApplicationMetaData();
        return metaData;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(J2eeApplicationMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        log.debug("newChild, " + localName);
        String version = attrs.getValue(namespaceURI, "version");
        if (version != null) {
            dd.setVersion(version);
        }
        if (localName.equals("icon")) {
            child = new IconMetaData();
        } else if (localName.equals("module")) {
            child = new J2eeModuleMetaData();
        } else if (localName.equals("security-role")) {
            child = new SecurityRoleMetaData();
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring: " + localName);
        }
        return child;
    }

    public Object newChild(J2eeModuleMetaData module, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        if (localName.equals("web")) {
            child = new WebModuleMetaData(module);
        } else if (localName.equals("security-role-ref")) {
            child = new SecurityRoleRefMetaData();
        }
        return child;
    }

    public void addChild(J2eeApplicationMetaData parent, J2eeModuleMetaData module, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addModule(module);
    }

    public void addChild(J2eeApplicationMetaData parent, SecurityRoleMetaData role, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addSecurityRole(role);
    }

    public void setValue(J2eeApplicationMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("display-name")) {
            dd.setDisplayName(value);
        } else if (localName.equals("description")) {
            dd.setDescription(value);
        } else if (localName.equals("library-directory")) {
            dd.setLibraryDirectory(value);
        }
    }

    public void setValue(IconMetaData icon, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("small-icon")) {
            icon.setSmallIcon(value);
        }
        if (localName.equals("large-icon")) {
            icon.setLargeIcon(value);
        }
    }

    public void setValue(J2eeModuleMetaData module, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("ejb")) {
            module.setType(0);
            module.setFileName(value);
        } else if (localName.equals("java")) {
            module.setType(2);
            module.setFileName(value);
        } else if (localName.equals("connector")) {
            module.setType(3);
            module.setFileName(value);
        } else if (localName.equals("service")) {
            module.setType(4);
            module.setFileName(value);
        } else if (localName.equals("har")) {
            module.setType(5);
            module.setFileName(value);
        } else if (localName.equals("alt-dd")) {
            module.setAlternativeDD(value);
        }
    }

    public void setValue(WebModuleMetaData module, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("web-uri")) {
            module.setFileName(value);
        } else if (localName.equals("context-root")) {
            module.setWebContext(value);
        } else if (localName.equals("alt-dd")) {
            module.setAlternativeDD(value);
        }
    }

    public void setValue(SecurityRoleMetaData role, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("description")) {
            role.setDescription(value);
        } else if (localName.equals("role-name")) {
            role.setRoleName(value);
        }
    }
}

