/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.HashSet;
import java.util.Set;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDependencyInfo
extends JBossObject
implements DependencyInfo {
    private Set<DependencyItem> iDependOn = CollectionsFactory.createCopyOnWriteSet();
    private Set<DependencyItem> dependsOnMe = CollectionsFactory.createCopyOnWriteSet();
    private Set<DependencyItem> unresolved = CollectionsFactory.createCopyOnWriteSet();

    @Override
    public Set<DependencyItem> getIDependOn(Class type) {
        if (type == null || this.iDependOn.isEmpty()) {
            return this.iDependOn;
        }
        HashSet<DependencyItem> set = new HashSet<DependencyItem>();
        for (DependencyItem item : this.iDependOn) {
            if (!type.isInstance(item)) continue;
            set.add(item);
        }
        return set;
    }

    @Override
    public void addIDependOn(DependencyItem dependency) {
        this.iDependOn.add(dependency);
        this.unresolved.add(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public void removeIDependOn(DependencyItem dependency) {
        this.iDependOn.remove(dependency);
        this.unresolved.remove(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public Set<DependencyItem> getDependsOnMe(Class type) {
        if (type == null || this.dependsOnMe.isEmpty()) {
            return this.dependsOnMe;
        }
        HashSet<DependencyItem> set = new HashSet<DependencyItem>();
        for (DependencyItem item : this.dependsOnMe) {
            if (!type.isInstance(item)) continue;
            set.add(item);
        }
        return set;
    }

    @Override
    public void addDependsOnMe(DependencyItem dependency) {
        this.dependsOnMe.add(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public void removeDependsOnMe(DependencyItem dependency) {
        this.dependsOnMe.remove(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public boolean resolveDependencies(Controller controller, ControllerState state) {
        boolean resolved = true;
        if (!this.unresolved.isEmpty()) {
            for (DependencyItem item : this.unresolved) {
                if (!state.equals(item.getWhenRequired()) || item.resolve(controller)) continue;
                resolved = false;
                break;
            }
        }
        return resolved;
    }

    @Override
    public Set<DependencyItem> getUnresolvedDependencies() {
        return this.unresolved;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("idependOn=").append(this.iDependOn);
        if (!this.unresolved.isEmpty()) {
            buffer.append(" unresolved=").append(this.unresolved);
        }
    }
}

