/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.patterns.observable;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aspects.patterns.observable.Observer;
import org.jboss.aspects.patterns.observable.Subject;

public class SubjectImpl
implements Subject {
    private Set observers = Collections.synchronizedSet(new HashSet());
    private Object subject;

    public SubjectImpl(Object subject) {
        this.subject = subject;
    }

    public void addObserver(Observer observer) {
        if (this.observers.contains(observer)) {
            return;
        }
        this.observers.add(observer);
    }

    public void removeObserver(Observer observer) {
        this.observers.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers() {
        Subject obj = (Subject)this.subject;
        Set set = this.observers;
        synchronized (set) {
            for (Observer observer : this.observers) {
                observer.fireChange(obj);
            }
        }
    }
}

