/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedConstructorInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class ConstructorJoinPointGenerator
extends JoinPointGenerator {
    public static final String GENERATOR_PREFIX = "generator_constructor_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_constructor_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_constructor_";
    private static final Class INVOCATION_TYPE = ConstructorInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public ConstructorJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info, JoinPointGenerator.JoinPointParameters.ONLY_ARGS, ((ConstructorInfo)info).getConstructor().getParameterTypes().length);
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = ConstructorJoinPointGenerator.getInfoClassName(this.classSimpleName(), this.index());
        this.joinpointFieldName = ConstructorJoinPointGenerator.getInfoFieldName(this.classSimpleName(), this.index());
    }

    private String classSimpleName() {
        Constructor ctor = ((ConstructorInfo)this.info).getConstructor();
        return Advisor.getSimpleName(ctor.getDeclaringClass());
    }

    private int index() {
        return ((ConstructorInfo)this.info).getIndex();
    }

    protected boolean isVoid() {
        return false;
    }

    protected Class getReturnType() {
        return ((ConstructorInfo)this.info).getConstructor().getDeclaringClass();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Constructor ctor = ((ConstructorInfo)this.info).getConstructor();
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getParameterTypes(), ctor.getExceptionTypes());
    }

    protected boolean hasTargetObject() {
        return false;
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index) throws NotFoundException, CannotCompileException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(ConstructorJoinPointGenerator.getJoinPointGeneratorFieldName(advisedClass.getSimpleName(), index));
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, advisedClass, advisedCtor, ciname, index);
        return generator.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return ConstructorJoinPointGenerator.getJoinPointGeneratorFieldName(this.classSimpleName(), this.index());
    }

    protected static String getInfoFieldName(String className, int index) {
        return JOINPOINT_FIELD_PREFIX + className + "_" + index;
    }

    private static String getInfoClassName(String className, int index) {
        return JOINPOINT_CLASS_PREFIX + className + "_" + index;
    }

    protected static String getJoinPointGeneratorFieldName(String className, int index) {
        return GENERATOR_PREFIX + className + "_" + index;
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass advisedClass;
        CtConstructor advisedCtor;
        String ciname;
        int index;
        CtClass jp;
        CtClass[] params;
        CtClass constructorInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.advisedClass = advisedClass;
            this.advisedCtor = advisedCtor;
            this.ciname = ciname;
            this.index = index;
            this.params = advisedCtor.getParameterTypes();
            this.constructorInfoClass = instrumentor.forName("org.jboss.aop.ConstructorInfo");
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.params, false);
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructors();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = ConstructorJoinPointGenerator.getInfoClassName(this.advisedClass.getSimpleName(), this.index);
            this.jp = TransformerCommon.makeNestedClass(this.advisedClass, className, true, 9, INVOCATION_CT_TYPE);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addPublicConstructor() throws CannotCompileException {
            CtConstructor publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.constructorInfoClass}, (CtClass[])new CtClass[0], (String)"{super($1, $1.getInterceptors()); this.info = $1;}", (CtClass)this.jp);
            this.jp.addConstructor(publicConstructor);
        }

        protected void addProtectedConstructors() throws CannotCompileException {
            CtClass[] ctorParams1 = new CtClass[this.params.length + 1];
            CtClass[] ctorParams2 = new CtClass[1];
            ctorParams1[0] = ctorParams2[0] = this.jp;
            System.arraycopy(this.params, 0, ctorParams1, 1, this.params.length);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            int offset = 1;
            StringBuffer setArguments = new StringBuffer();
            for (int i = offset; i < ctorParams1.length; ++i) {
                setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            setArguments.append("}");
            CtConstructor protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams1, (CtClass[])new CtClass[0], (String)(body.toString() + setArguments.toString()), (CtClass)this.jp);
            protectedConstructor.setModifiers(4);
            this.jp.addConstructor(protectedConstructor);
            if (this.params.length > 0) {
                protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams2, (CtClass[])new CtClass[0], (String)(body.toString() + "}"), (CtClass)this.jp);
                protectedConstructor.setModifiers(4);
                this.jp.addConstructor(protectedConstructor);
            }
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            CtMethod invokeJoinpointMethod = CtNewMethod.make((CtClass)this.advisedClass, (String)"invokeJoinpoint", (CtClass[])this.params, (CtClass[])this.advisedCtor.getExceptionTypes(), null, (CtClass)this.jp);
            invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(invokeJoinpointMethod);
            return invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.constructorInfoClass, "info", this.jp);
            infoField.setModifiers(4);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            OptimizedConstructorInvocations.addDispatch(this.jp, "dispatch", this.advisedCtor);
            if (this.params.length > 0) {
                this.addInvokeJoinPointDispatchMethod();
            }
            this.addInvokeTargetMethod();
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            String body = "{   " + this.advisedClass.getName() + " obj = new " + this.advisedClass.getName() + "($$);" + "   setTargetObject(obj);" + "   return obj;" + "}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)this.advisedClass, (String)"dispatch", (CtClass[])this.params, (CtClass[])this.advisedCtor.getExceptionTypes(), (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
            }
        }

        private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException {
            CtMethod template = INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
            String body = "{return dispatch();}";
            CtMethod invokeTarget = CtNewMethod.make((CtClass)template.getReturnType(), (String)template.getName(), (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)body, (CtClass)this.jp);
            this.jp.addMethod(invokeTarget);
        }
    }
}

