/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.ConstructionInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.ConstructionTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.ConstructionInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class ConstructionJoinPointGenerator
extends JoinPointGenerator {
    public static final String GENERATOR_PREFIX = "generator_construction_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_construction_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_construction_";
    private static final Class INVOCATION_TYPE = ConstructionInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public ConstructionJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info, JoinPointGenerator.JoinPointParameters.TARGET_ARGS, ((ConstructionInfo)info).getConstructor().getParameterTypes().length);
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = ConstructionJoinPointGenerator.getInfoClassName(this.classSimpleName(), this.index());
        this.joinpointFieldName = ConstructionJoinPointGenerator.getInfoFieldName(this.classSimpleName(), this.index());
    }

    private String classSimpleName() {
        Constructor ctor = ((ConstructionInfo)this.info).getConstructor();
        return Advisor.getSimpleName(ctor.getDeclaringClass());
    }

    private int index() {
        return ((ConstructionInfo)this.info).getIndex();
    }

    protected boolean isVoid() {
        return true;
    }

    protected Class getReturnType() {
        return null;
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Constructor ctor = ((ConstructionInfo)this.info).getConstructor();
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getParameterTypes(), ctor.getExceptionTypes(), ctor.getDeclaringClass(), true);
    }

    protected boolean hasTargetObject() {
        return true;
    }

    protected String getInfoName() {
        return ConstructionTransformer.getConstructionInfoFieldName(Advisor.getSimpleName(this.advisor.getClazz()), ((ConstructionInfo)this.info).getIndex());
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index) throws NotFoundException, CannotCompileException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(ConstructionJoinPointGenerator.getJoinPointGeneratorFieldName(advisedClass.getSimpleName(), index));
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, advisedClass, advisedCtor, ciname, index);
        return generator.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return ConstructionJoinPointGenerator.getJoinPointGeneratorFieldName(this.classSimpleName(), this.index());
    }

    protected static String getInfoFieldName(String className, int index) {
        return JOINPOINT_FIELD_PREFIX + className + "_" + index;
    }

    private static String getInfoClassName(String className, int index) {
        return JOINPOINT_CLASS_PREFIX + className + "_" + index;
    }

    protected static String getJoinPointGeneratorFieldName(String className, int index) {
        return GENERATOR_PREFIX + className + "_" + index;
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass advisedClass;
        CtConstructor advisedCtor;
        String ciname;
        int index;
        CtClass jp;
        CtField targetField;
        CtClass[] originalParams;
        CtClass[] params;
        CtClass constructionInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.advisedClass = advisedClass;
            this.advisedCtor = advisedCtor;
            this.ciname = ciname;
            this.index = index;
            this.originalParams = advisedCtor.getParameterTypes();
            this.params = new CtClass[this.originalParams.length + 1];
            this.params[0] = advisedClass;
            System.arraycopy(this.originalParams, 0, this.params, 1, this.originalParams.length);
            this.constructionInfoClass = instrumentor.forName("org.jboss.aop.ConstructionInfo");
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.originalParams, false);
            this.addTypedTargetField();
            this.addInvokeJoinpointMethod();
            this.addConstructionInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructors();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = ConstructionJoinPointGenerator.getInfoClassName(this.advisedClass.getSimpleName(), this.index);
            this.jp = TransformerCommon.makeNestedClass(this.advisedClass, className, true, 9, INVOCATION_CT_TYPE);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addTypedTargetField() throws CannotCompileException {
            this.targetField = new CtField(this.advisedClass, "typedTargetObject", this.jp);
            this.jp.addField(this.targetField);
            this.targetField.setModifiers(4);
        }

        private void addPublicConstructor() throws CannotCompileException {
            CtConstructor publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.constructionInfoClass}, (CtClass[])new CtClass[0], (String)"{super($1, $1.getInterceptors()); this.info = $1;}", (CtClass)this.jp);
            this.jp.addConstructor(publicConstructor);
        }

        protected void addProtectedConstructors() throws CannotCompileException {
            CtClass[] ctorParams1 = new CtClass[this.params.length + 1];
            CtClass[] ctorParams2 = new CtClass[2];
            ctorParams1[0] = ctorParams2[0] = this.jp;
            System.arraycopy(this.params, 0, ctorParams1, 1, this.params.length);
            ctorParams2[1] = this.params[0];
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            int offset = 2;
            body.append("   this." + this.targetField.getName() + " = $2;");
            body.append("   super.setTargetObject($2);");
            StringBuffer setArguments = new StringBuffer();
            for (int i = offset; i < ctorParams1.length; ++i) {
                setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            setArguments.append("}");
            CtConstructor protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams1, (CtClass[])new CtClass[0], (String)(body.toString() + setArguments.toString()), (CtClass)this.jp);
            protectedConstructor.setModifiers(4);
            this.jp.addConstructor(protectedConstructor);
            if (this.params.length > 1) {
                protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams2, (CtClass[])new CtClass[0], (String)(body.toString() + "}"), (CtClass)this.jp);
                protectedConstructor.setModifiers(4);
                this.jp.addConstructor(protectedConstructor);
            }
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            CtMethod invokeJoinpointMethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)"invokeJoinpoint", (CtClass[])this.params, (CtClass[])this.advisedCtor.getExceptionTypes(), null, (CtClass)this.jp);
            invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(invokeJoinpointMethod);
            return invokeJoinpointMethod;
        }

        private void addConstructionInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.constructionInfoClass, "info", this.jp);
            infoField.setModifiers(4);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            this.addInvokeNextDispatchMethod();
            this.addInvokeJoinPointDispatchMethod();
        }

        private void addInvokeNextDispatchMethod() throws CannotCompileException, NotFoundException {
            String body = "{ return null;}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)CtClass.voidType, (String)"dispatch", (CtClass[])JoinPointGenerator.EMPTY_CTCLASS_ARRAY, (CtClass[])this.advisedCtor.getExceptionTypes(), (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", JoinPointGenerator.EMPTY_CTCLASS_ARRAY), e);
            }
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            String body = "{ return null;}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)CtClass.voidType, (String)"dispatch", (CtClass[])this.params, (CtClass[])this.advisedCtor.getExceptionTypes(), (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
            }
        }
    }
}

